<?php $__env->startSection('content'); ?>
    <div class="mb-4">
        <?php if($canCreate): ?>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalTambah">Tambah TBM</button>
        <?php endif; ?>
    </div>
    <div class="card">
        <div class="card-body">
            <table id="activeTable" class="table table-striped data-table">
                <thead>
                    <tr>
                        <th id="no">No</th>
                        <th>Nama</th>
                        <th>Lokasi</th>
                        <th>Topik</th>
                        <th>Keterangan</th>
                        <th width="105px">Action</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>


    <?php echo $__env->make('stbm.modal.add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('stbm.modal.edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <template id="participant-template">
        <div class="row">
            <div class="col-lg-10">
                <input type="text" name="participant[]" class="form-control" value="" placeholder="Masukkan nama" id=""
                    required>
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-danger delete-participant"><i class="fa fa-trash"></i></button>
            </div>
        </div>
    </template>
    <template id="images-template">
        <div class="row">
            <div class="col-lg-10">
                <input type="file" name="images[]" class="form-control" accept="image/*" id="" required>
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-danger delete-image" data-id="{id}"><i
                        class="fa fa-trash"></i></button>
            </div>
        </div>
    </template>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('extraJS'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $(function () {
                var table = $('#activeTable').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "<?php echo e(route('stbm.index')); ?>",
                        data: function (d) {
                            d.option = "active";
                        },
                    },
                    columnDefs: [{
                        width: "50px",
                        targets: 0
                    } // 0 adalah index kolom 'id'
                    ],
                    columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        className: 'text-center',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'location',
                        name: 'location'
                    },
                    {
                        data: 'topic',
                        name: 'topic'
                    },
                    {
                        data: 'description',
                        name: 'description',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                    ]
                });
            });
            $(document).on("click", ".add-participant", function () {
                const wrapper = $(this).closest("div").find(".participant")
                const count = $(wrapper).children().length;
                let template = $("#participant-template").html()
                template = template.replace("participant[]", `participant[${count}]`);
                $(wrapper).append(template)
            })
            $(document).on("click", ".delete-participant", function () {
                const id = $(this).data("id")
                $(this).closest(".row").remove()
            })
            $(document).on("click", ".add-image", function () {
                const wrapper = $(this).closest("div").find(".images")
                const count = $(wrapper).children().length;
                let template = $("#images-template").html()
                template = template.replace("images[]", `images[${count}]`);
                $(wrapper).append(template)
            })
            $(document).on("click", ".delete-image", function () {
                const id = $(this).data("id")
                const form = $(this).closest("form").find(".deleted-images")
                $(form).append(
                    `<input type="hidden" name="deleted_images[]" value="${id}">`
                );
                $(this).closest(".row").remove()
            })
            $(document).on("click", ".delete-image-table", function () {
                const id = $(this).data("id")
                const form = $(this).closest("form").find(".deleted-images")
                $(form).append(
                    `<input type="hidden" name="deleted_images[]" value="${id}">`
                );
                $(`[name='old_images[${id}]']`).remove()
                $(this).parent().parent().find("input").attr("disabled", false)
                $(this).parent().remove()
            })


            // edit

            // delete
            $(document).on("click", ".delete", function () {
                var id = $(this).data("id");

                Swal.fire({
                    title: 'Apakah kamu yakin?',
                    text: "Data akan dihapus secara permanen!",
                    icon: 'warning',
                    showCancelButton: true,
                    cancelButtonColor: '#3085d6',
                    confirmButtonColor: '#d33',
                    confirmButtonText: 'Ya, hapus!',
                    cancelButtonText: 'Batal'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: `<?php echo e(route('stbm.destroy', ':id')); ?>`.replace(':id', id),
                            type: 'DELETE',
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            success: function (res) {
                                Swal.fire('Terhapus!', res.message, 'success');
                                $('.data-table').DataTable().ajax.reload();
                            },
                            error: function (xhr) {
                                Swal.fire('Gagal!', 'Data gagal dihapus.', 'error');
                            }
                        });
                    }
                });
            });
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('template.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pmme2286/public_html/docu/vendor1/resources/views/stbm/index.blade.php ENDPATH**/ ?>