<?php $__env->startSection('content'); ?>
    <div class="row">
        <?php
            $colors = ['primary', 'secondary', 'danger', 'warning'];
        ?>

        <?php $__currentLoopData = $equipmentStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-3 mb-3">
                <div class="card bg-<?php echo e($colors[$index % count($colors)]); ?>">
                    <div class="card-body">
                        <div class="card-text">
                            <h6 class="text-white">Total Unit <?php echo e($stat->type_name); ?></h6>
                            <h3 class="text-white"><?php echo e($stat->total_equipment); ?></h3>
                            <h6 class="text-white">Jumlah Unit <?php echo e($stat->type_name); ?>.</h6>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="container">
        <!-- Tabs Sites -->
        <ul class="nav nav-tabs" id="siteTabs" role="tablist">
            <?php $__currentLoopData = $sites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $site): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="nav-item">
                    <button class="nav-link <?php if($loop->first): ?> active <?php endif; ?>" data-bs-toggle="tab"
                        data-bs-target="#site-<?php echo e(Str::slug($site->id)); ?>">
                        <?php echo e($site->name); ?>

                    </button>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <li class="nav-item ms-auto">
                <form action="" method="get">
                    <input type="date" onchange="this.form.submit()" class="form-control"
                        value="<?php echo e(request()->tanggal); ?>" name="tanggal" id="">
                </form>
            </li>
        </ul>

        <!-- Content per Site -->
        <div class="tab-content mt-3">
            <?php $__currentLoopData = $sites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $site): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="tab-pane fade <?php if($loop->first): ?> show active <?php endif; ?>"
                    id="site-<?php echo e(Str::slug($site->id)); ?>">
                    <?php $__currentLoopData = $site->shifts(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shift): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card mb-3">
                            <div class="card-header">
                                Shift - <?php echo e($shift->name); ?>

                            </div>
                            <div class="card-body d-flex gap-4 flex-wrap">
                                <?php $__currentLoopData = $site->units->sortBy(function ($item) {
                                    if (Str::startsWith($item->unit_code, 'L-')) {
                                        return 1;
                                    }
                                    if (Str::startsWith($item->unit_code, 'E-')) {
                                        return 2;
                                    }
                                    if (Str::startsWith($item->unit_code, 'DT-')) {
                                        return 3;
                                    }
                                    if (Str::startsWith($item->unit_code, 'S-')) {
                                        return 4;
                                    }
                                    return 5;
                                }); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $status =
                                            $groupedBySiteShift[$item->id . '_' . $shift->id]->status_checklist ??
                                            'Belum Checklist';
                                        $map = [
                                            'Baik' => ['color' => '#007bff'],
                                            'Cukup' => ['color' => '#fd7e14'],
                                            'Rusak' => ['color' => '#DD0303'],
                                            'Rusak Fatal' => ['color' => '#6c757d'],
                                            'Belum Checklist' => ['color' => ''],
                                            'N/A' => ['color' => '#6c757d'],
                                        ];

                                        $color = $map[$status]['color'];
                                        $label = $status;

                                        $imagePath = $item->unittype->image
                                            ? asset($item->unittype->image)
                                            : asset('images/default-icon.png'); // icon hitam default
                                    ?>

                                    <div class="text-center">
                                        <div><?php echo e($item->unit_code ?? 'Unknown'); ?></div>
                                        <div
                                            style="
                                                width: 100px;
                                                height: 100px;
                                                position: relative;
                                                border-radius: 8px;
                                                background-color: <?php echo e($color); ?>;
                                                display: flex;
                                                align-items: center;
                                                justify-content: center;
                                                overflow: hidden;
                                            ">
                                            <img src="<?php echo e($imagePath); ?>" alt="<?php echo e($item->unit_code); ?>"
                                                style="
                                                max-width: 70%;
                                                max-height: 70%;
                                                object-fit: contain;
                                                position: absolute;
                                                z-index: 2;
                                            ">
                                        </div>
                                        <strong><?php echo e($label); ?></strong>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extraJS'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('template.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pmme2286/public_html/docu/vendor1/resources/views/dashboard.blade.php ENDPATH**/ ?>