<!DOCTYPE html>
<html>

<head>
    <title>Daily Report - <?php echo e($daily->code_report); ?></title>
    <link rel="stylesheet" href="<?php echo e(public_path('font-awesome-4.7.0/css/font-awesome.min.css')); ?>">
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 11px;
        }

        h1,
        h2,
        h3 {
            margin: 0;
            padding: 0;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            border-bottom: 2px solid #000;
            padding-bottom: 5px;
            margin-bottom: 10px;
        }

        .header-left {
            width: 70%;
        }

        .header-left h1 {
            font-size: 18px;
            font-weight: bold;
        }

        .header-left p {
            margin: 2px 0;
        }

        .header-right {
            width: 100%;
            text-align: right;
        }

        .header-right img {
            width: 70px;
        }

        .report-info {
            margin-top: 10px;
            margin-bottom: 10px;
        }

        .report-info table {
            width: 100%;
            border-collapse: collapse;
        }

        .report-info td {
            padding: 2px 5px;
            vertical-align: top;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        .table th,
        .table td {
            border: 1px solid #000;
            padding: 0px 4px;
        }

        .table th {
            background: #f3f3f3;
        }

        .text-left {
            text-align: left;
        }

        .text-center {
            text-align: center;
        }

        .no-border {
            border: none !important;
        }
    </style>
</head>

<body>
    <table style="width: 100%; border-bottom: 2px solid #000; margin-bottom: 10px;">
        <tr>
            <td style="width: 70%; vertical-align: top;">
                <h1 style="font-size: 18px; font-weight: bold; margin: 0;"><?php echo e($daily->form->title); ?></h1>
                <p style="margin: 3px 0 0 0;">
                    Checklist unit operator untuk <?php echo e($daily->unit->unittype->name); ?> per hari
                </p>
            </td>
            <td style="width: 30%; text-align: right; vertical-align: top;">
                <img src="<?php echo e(public_path('images/logo.jpg')); ?>" style="width: 120px;" alt="logo">
            </td>
        </tr>
    </table>


    <div class="report-info">
        <table>
            <tr>
                <td><strong>Report # :</strong></td>
                <td><?php echo e($daily->code_report); ?></td>
            </tr>
            <tr>
                <td><strong>Unit Name :</strong></td>
                <td><?php echo e($unit->unittype->name); ?></td>
            </tr>
            <tr>
                <td><strong>Unit # :</strong></td>
                <td><?php echo e($unit->unit_code); ?></td>
            </tr>
            <tr>
                <td><strong>Shift :</strong></td>
                <td>Shift <?php echo e($daily->shift->name); ?></td>
            </tr>
            
        </table>
    </div>

    <?php
        use Carbon\Carbon;

        $now = Carbon::now('Asia/Jakarta')->locale('id');
        $no = 1;
        $days = ['Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab', 'Min'];
        $currentDayIndex = $now->dayOfWeekIso - 1;
    ?>

    
    <table class="table table-bordered"
        style="width: 100%; text-align:center; border-collapse: collapse; font-size: 12px;">
        <tbody>
            <tr>
                <td style="background-color: #e0e0e0; font-weight:bold; width: 100px;">Hari</td>
                <?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td><?php echo e($day); ?></td>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
            <tr>
                <td style="background-color: #e0e0e0; font-weight:bold;">Tanggal & Jam</td>
                <?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php if($i === $currentDayIndex): ?>
                            <?php echo e($now->translatedFormat('d-F-Y H:i:s')); ?>

                        <?php endif; ?>
                    </td>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
            
        </tbody>
    </table>

    <table class="table" style="margin-top: 10px;">
        <thead>
            <tr>
                <th>SN</th>
                <th class="text-left">Keseluruhan Unit</th>
                <?php $__currentLoopData = $status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <th><?php echo e($item->name); ?></th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <th>Catatan</th>
            </tr>
        </thead>
        <tbody>

            <?php $__currentLoopData = $daily->form->sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $section->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $currentDailyItem = $daily_item->firstWhere('form_item_id', $item->id);
                    ?>
                    <tr>
                        <td><?php echo e($no++); ?></td>
                        <td><?php echo e($item->name); ?></td>

                        <?php $__currentLoopData = $status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $st): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td style="text-align:center;">
                                <?php if($currentDailyItem && $currentDailyItem->status_id == $st->id): ?>
                                    <?php
                                        $color = '#000000';
                                        if ($st->name == 'Baik') {
                                            $color = 'green';
                                        } elseif ($st->name == 'Rusak') {
                                            $color = 'red';
                                        } elseif ($st->name == 'Cukup') {
                                            $color = '#FFDE21';
                                        }
                                    ?>
                                    <span style="color:<?php echo e($color); ?>;font-size:12px">✔</span>
                                <?php endif; ?>
                            </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <td><?php echo e($currentDailyItem->note ?? ''); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tbody>
        <tfoot>
            <?php
                $count = $status->count();
            ?>
            <tr>
                <td colspan="2" style="text-align: left;">Comment (*)</td>
                <td colspan="<?php echo e($count + 1); ?>"><?php echo e($daily->comment); ?></td>
            </tr>
        </tfoot>
    </table>

    
    <table class="table table-bordered"
        style="width: 100%; text-align:center; border-collapse: collapse; font-size: 12px; margin-top: 5px;">
        <tbody>
            <tr>
                <td style="background-color: #e0e0e0; font-weight:bold; width: 100px;">Operator</td>
                <?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php if($i === $currentDayIndex): ?>
                            <?php echo e($daily->user->name ?? '-'); ?>

                        <?php endif; ?>
                    </td>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
            <tr>
                <td style="background-color: #e0e0e0; font-weight:bold;">Shift</td>
                <?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php if($i === $currentDayIndex): ?>
                            Shift - <?php echo e($daily->shift->name ?? '-'); ?>

                        <?php endif; ?>
                    </td>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        </tbody>
    </table>

    
</body>

</html>
<?php /**PATH /home/pmme2286/public_html/docu/vendor1/resources/views/daily/pdf/index.blade.php ENDPATH**/ ?>