<?php

use App\Http\Controllers\ActionController;
use App\Http\Controllers\ApproveController;
use App\Http\Controllers\ChecklistController;
use App\Http\Controllers\ChecklistItemController;
use App\Http\Controllers\ChecklistSectionController;
use App\Http\Controllers\DailyController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\ManufactureController;
use App\Http\Controllers\MonthlyController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\RolesController;
use App\Http\Controllers\ShiftController;
use App\Http\Controllers\StatusController;
use App\Http\Controllers\StbmController;
use App\Http\Controllers\SwpController;
use App\Http\Controllers\UnitTypeController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::prefix(config("app.prefix"))->group(function () {

    Route::get('/', function () {
        return redirect()->route("login");
    });
    Route::get('/register', function () {
        return redirect()->back();
    });
    Route::get('/dashboard', [DashboardController::class, 'index'])->middleware(['auth', 'verified'])->name('dashboard');

    Route::middleware(['auth'])->group(function () {
        Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
        Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
        Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

        Route::middleware(["roleAkses"])->group(function () {
            Route::resource('/locations', LocationController::class);
            Route::resource("/users", UserController::class);
            Route::resource("/aprrove", ApproveController::class);
            Route::resource('/roles', RolesController::class);
            Route::resource('/status-checklist', StatusController::class);
            Route::resource('/shift', ShiftController::class);
            Route::resource('/actions', ActionController::class);
            route::resource('/unit-type', UnitTypeController::class);
            Route::resource('/units', UnitController::class);
            Route::resource('/manufactures', ManufactureController::class);
            Route::resource('/swp', SwpController::class);
            Route::resource('/stbm', StbmController::class)->except("create", "edit");

            // data check list
            route::resource('/checklist', ChecklistController::class);
            route::resource('/checklist-sections', ChecklistSectionController::class);
            route::resource('/checklist-items', ChecklistItemController::class);

            // dailies
            route::resource('/daily-report', DailyController::class);

            route::resource('/monthly-report', MonthlyController::class)->except(["store", "update", "show", "destroy", "create"]);
        });


        Route::prefix('api')->group(function () {
            Route::get('/get-role-akses/{id}', [RolesController::class, 'getRoleAkses'])->name('roles.akses');
        });

        Route::get('monthly/{untId}/{month}/{year}/{shift}/pdf', [MonthlyController::class, 'generatePdf'])->name('monthly.pdf');
        Route::get('/get-form-by-unit/{id}', [ChecklistController::class, 'getByType'])->name('get-form-by-type-unit');
        Route::post('/daily-report/download-all', [DailyController::class, 'downloadAll'])->name('daily-report.downloadAll');
        Route::get('/stbm/pdf/{id}', [StbmController::class, 'donwloadPdf'])->name('stbm.pdf');
        // Route::get('/history', [DailyController::class, 'create']);
    });




    require __DIR__ . '/auth.php';
});
