<?php

use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\CheckListController;
use App\Http\Controllers\Api\MasterController;
use App\Http\Controllers\ChecklistController as ControllersChecklistController;
use Illuminate\Http\Request;
use App\Http\Controllers\Api\StbmController;
use App\Http\Controllers\Api\SwpController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Auth Api Route

// Route::prefix(config("app.prefix"))->group(function () {
    

Route::post('/login', [AuthController::class, 'Login']);
// dd(request()->path(),config("app.prefix")."/api");
Route::group(['middleware' => 'auth:sanctum'], function () {

    Route::post('/logout', [AuthController::class, 'logout']);

    Route::post('/user/update-password', [AuthController::class, 'updatePassword']);

    Route::get('/all-user', [MasterController::class, 'getAllUser']);
    
    Route::get('/all-location', [MasterController::class, 'getAllLocation']);

    Route::get('/all-unit', [MasterController::class, 'getAllUnit']);

    Route::get('/all-form', [MasterController::class, 'getAllForm']);

    Route::get('/all-checklist', [CheckListController::class, 'getAllChecklist']);

    Route::get('/all-approval', [MasterController::class, 'getAllAproval']);

    Route::post('/update-approval', [MasterController::class, 'updateApprove']);

    Route::get('/shifts', [CheckListController::class, 'getAllShift']);

    Route::get('/unit/{id}', [CheckListController::class, 'getUnitByForm']);

    Route::get('/checklist/{id}/detail', [CheckListController::class, 'getQuestion']);

    Route::post('/dailies', [CheckListController::class, 'store']);

    Route::get('/history', [CheckListController::class, 'getHistory']);

    Route::get('/delete-history/{id}', [ChecklistController::class, 'deleteHistory']);

    Route::get('/pdf/{id}', [CheckListController::class, 'pdf']);
    
    Route::get('/get-daily-status', [CheckListController::class, 'getDailyStatus']);
    

    // Route TBM
    Route::get("/stbm", [StbmController::class, "index"]);
    Route::post("/stbm", [StbmController::class, "store"]);
    Route::get("/stbm/{id}", [StbmController::class, "show"]);
    Route::post("/stbm/{id}", [StbmController::class, "update"]);
    Route::delete("/stbm/{id}", [StbmController::class, "destroy"]);
    Route::get('/stbm/pdf/{id}', [StbmController::class, 'donwloadPdf']);

    Route::get('/swp', [SwpController::class, 'index']);
    Route::get('/swp/pdf/{id}', [SwpController::class, 'downloadPdf']);

    Route::get('/all-location', [StbmController::class, 'getLocation']);

});


Route::middleware('auth:sanctum')->get('/check-token', function (Request $request) {
    return response()->json([
        'status' => 'success',
        'message' => 'Token valid'
    ]);
});

// });


//   Route::get('/*', function(){
//       return response()->json([
//         'status' => 'success',
//         'message' => 'Token valid'
//     ]);
//   });
