@php
    $mainTitle = 'DASHBOARD';
    $subTitle = null;

    // DASHBOARD
    if (request()->routeIs('dashboard')) {
        $mainTitle = 'DASHBOARD';
    }

    // MASTER DATA
    elseif (
        request()->routeIs('users.*') ||
        request()->routeIs('roles.*') ||
        request()->routeIs('actions.*') ||
        request()->routeIs('locations.*') ||
        request()->routeIs('status-checklist.*') ||
        request()->routeIs('shift.*') ||
        request()->routeIs('manufactures.*')
    ) {
        $mainTitle = 'MASTER DATA';

        $map = [
            'users.*' => 'USER',
            'roles.*' => 'ROLE',
            'actions.*' => 'ACTION',
            'locations.*' => 'LOCATION',
            'status-checklist.*' => 'STATUS CHECKLIST',
            'shift.*' => 'SHIFT',
            'manufactures.*' => 'MANUFACTURE',
        ];

        foreach ($map as $route => $label) {
            if (request()->routeIs($route)) {
                $subTitle = $label;
                break;
            }
        }
    }

    // UNIT TYPE
    elseif (request()->routeIs('unit-type.*')) {
        $mainTitle = 'UNIT TYPE';
    }

    // UNIT LIST
    elseif (request()->routeIs('units.*')) {
        $mainTitle = 'UNIT LIST';
    }

    // DATA CHECKLIST
    elseif (request()->routeIs('checklist.*')) {
        $mainTitle = 'DATA CHECKLIST';
    }

    // ISI CHECKLIST
    elseif (request()->routeIs('daily-report.*') || request()->routeIs('monthly-report.*')) {
        $mainTitle = 'ISI CHECKLIST';
        $map = [
            'daily-report.*' => 'CHECKLIST HARIAN',
            'monthly-report.*' => 'CHECKLIST BULANAN',
        ];

        foreach ($map as $route => $label) {
            if (request()->routeIs($route)) {
                $subTitle = $label;
                break;
            }
        }
    }

    // SWP
    elseif (request()->routeIs('swp.*')) {
        $mainTitle = 'SWP';
    }

    // TBM
    elseif (request()->routeIs('stbm.*')) {
        $mainTitle = 'TBM';
    }
@endphp

<div class="mb-3">
    <h4 class="fw-bold text-uppercase">
        {{ $mainTitle }}
        @if ($subTitle)
            / {{ $subTitle }}
        @endif
    </h4>
    <hr class="mt-2">
</div>
