<!doctype html>
<html lang="en">

<head>
    @include('template.header')
</head>

<body>
    <div class="loading" style="display:none;">
        <div class="position-fixed top-0 start-0 w-100 h-100 d-flex justify-content-center align-items-center"
            style="z-index: 99999; background-color: rgba(0, 0, 0, .7);" id="loading">
            <img src="{{ asset('images/loading.svg') }}" style="width: 100%; max-width: 200px;" alt="Loading...">
        </div>
    </div>

    <!--  Body Wrapper -->
    <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
        data-sidebar-position="fixed" data-header-position="fixed">
        <!-- Sidebar Start -->
        <!--  Sidebar End -->
        <!--  Main wrapper -->
        <div class="body-wrapper">
            <!--  Header Start -->
            @include('template.navbar')
            @include('template.sidebar')
            <!--  Header End -->
            <div class="container-fluid">
                <!--  Row 1 -->
                @include('template.pagetittle')
                @yield('content')

                @include('template.footer')
            </div>
        </div>
    </div>
    @include('template.js')
    @if (session('error'))
        <script>
            Swal.fire({
                icon: 'error',
                title: 'Akses Ditolak',
                text: '{{ session('error') }}',
                confirmButtonColor: '#d33'
            })
        </script>
    @endif
    <script>
        $(document).ready(function() {
            setTimeout(() => {
                $(".loading").hide();
                $('body').css('overflow', '');
            }, 1000);

            $("form").on("submit", function(e) {
                $(".loading").show();
                $('body').css('overflow', 'hidden');
                setTimeout(() => {
                    $(".loading").hide();
                    $('body').css('overflow', '');
                }, 1000);
            });
        })
        $(document).ready(function() {

            $('.loading').hide();

            $(window).on('load', function() {
                $('.loading').fadeOut('slow');
            });

            // 🔹 Tampilkan loading ketika form disubmit
            $(document).on('submit', 'form', function() {
                $('.loading').fadeIn('fast');
                $('body').css('overflow', 'hidden');
            });
        });
        $(document).ready(function() {
            // Handle semua link kecuali target="_blank", #, javascript:
            $(document).on('click', 'a[href]:not([target="_blank"]):not([href^="#"]):not([href^="javascript:"])',
                function(e) {
                    const href = $(this).attr('href');
                    e.preventDefault();
                    $('.loading').show();
                    $('body').css('overflow', 'hidden');
                    setTimeout(() => {
                        window.location.href = href;
                    }, 100);
                });

            // Handle tombol back/forward browser (popstate)
            // window.addEventListener('popstate', function () {
            //     $('.loading').show();
            // });

            // Handle jika halaman dimuat kembali dari cache (back/forward bisa trigger ini)
            // window.addEventListener('pageshow', function (event) {
            //     if (event.persisted) {
            //         $('.loading').show();
            //     }
            // });

            window.addEventListener("pageshow", function(event) {
                // jika halaman dimuat dari cache (persisted true) atau navigasi back/forward
                if (event.persisted || performance.getEntriesByType("navigation")[0]?.type ===
                    "back_forward") {
                    $(".loading").hide(); // pastikan loading disembunyikan
                    $('body').css('overflow', '');
                }
            });

            // kalau mau munculkan loading saat pindah halaman dengan back/forward
            window.addEventListener("pagehide", function() {
                $(".loading").show();
                $('body').css('overflow', 'hidden');
            });
        });
    </script>


    <script>
        // $(document).on('show.bs.dropdown', '.dropdown', function () {
        //     var $dropdown = $(this);
        //     var $button = $dropdown.find('[data-bs-toggle="dropdown"]');
        //     var $menu = $dropdown.find('.dropdown-menu');

        //     // Ambil posisi tombol
        //     var offset = $button.offset();
        //     var height = $button.outerHeight();

        //     // Set posisi fixed sebelum dropdown ditampilkan
        //     $menu.css({
        //         'display': 'block',
        //         'position': 'fixed',
        //         'top': offset.top + height,
        //         'left': offset.left,
        //         'z-index': 9999
        //     });
        // });

        // // Reset ketika dropdown ditutup
        // $(document).on('hide.bs.dropdown', '.dropdown', function () {
        //     $(this).find('.dropdown-menu').css({
        //         'display': '',
        //         'position': '',
        //         'top': '',
        //         'left': '',
        //         'z-index': ''
        //     });
        // });
    </script>
</body>

</html>
