@extends('template.master')
{{-- modal --}}

{{-- modal --}}
@section('content')
    @if ($canCreate)
        <x-primary-button data-bs-toggle="modal" data-bs-target="#modalTambah" class="mb-4">Tambah SWP</x-primary-button>
    @endif

    <div class="card">
        <div class="card-body">
            <table id="activeTable" class="table table-striped data-table">
                <thead>
                    <tr>
                        <th id="no">No</th>
                        <th>Judul</th>
                        <th>User</th>
                        <th width="105px">Action</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>


    @include('swp.modal.add')
    @include('swp.modal.edit')
@endsection
@push('extraJS')
    <script type="text/javascript">
        $(document).ready(function () {
            $(function () {
                var table = $('#activeTable').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('swp.index') }}",
                        data: function (d) {
                            d.option = "active";
                        },
                    },
                    columnDefs: [{
                        width: "50px",
                        targets: 0
                    } // 0 adalah index kolom 'id'
                    ],
                    columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        className: 'text-center',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'title',
                        name: 'title'
                    },
                    {
                        data: 'user',
                        name: 'user'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                    ]
                });
            });

            $('#formTambah').on('submit', function (e) {
                e.preventDefault();

                const form = $(this);
                const title = $('#title').val().trim();
                const file = $('#file').val();

                if (!title || !file) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Validasi Gagal',
                        text: 'Judul dan file wajib diisi.'
                    });
                    return;
                }

                const formData = new FormData(this);

                $.ajax({
                    url: '{{ route('swp.store') }}',
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function (response) {
                        $('#modalTambah').modal('hide');
                        form.trigger("reset");

                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        });

                        $('.data-table').DataTable().ajax.reload();
                    },
                    error: function (xhr) {
                        let message = xhr.responseJSON?.message || 'Terjadi kesalahan';
                        Swal.fire({
                            icon: 'error',
                            title: 'Gagal Menyimpan',
                            text: message
                        });
                    }
                });
            });


            // edit
            $(document).on('click', '.edit', function () {
                let id = $(this).data('id');
                let title = $(this).data('title');

                $('#edit-id').val(id);
                $('#edit-title').val(title);
                $('#modalEdit').modal('show');
            });

            // Handle form submit edit
            $('#formEdit').on('submit', function (e) {
                e.preventDefault();
                const form = $(this);

                let id = $('#edit-id').val();
                let title = $('#edit-title').val().trim();

                if (!title) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Validasi Gagal',
                        text: 'Judul wajib diisi.'
                    });
                    return;
                }

                $.ajax({
                    url: `{{ route('swp.update', ':id') }}`.replace(':id', id),
                    type: 'PUT',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: form.serialize(),
                    success: function (response) {
                        $('#modalEdit').modal('hide');

                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        });

                        $('.data-table').DataTable().ajax.reload();
                    },
                    error: function (xhr) {
                        let message = xhr.responseJSON?.message ||
                            'Terjadi kesalahan saat update.';
                        Swal.fire({
                            icon: 'error',
                            title: 'Gagal Update',
                            text: message
                        });
                    }
                });
            });
            // delete
            $(document).on("click", ".delete", function () {
                var id = $(this).data("id");

                Swal.fire({
                    title: 'Apakah kamu yakin?',
                    text: "Data akan dihapus secara permanen!",
                    icon: 'warning',
                    showCancelButton: true,
                    cancelButtonColor: '#3085d6',
                    confirmButtonColor: '#d33',
                    confirmButtonText: 'Ya, hapus!',
                    cancelButtonText: 'Batal'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: `{{ route('swp.destroy', ':id') }}`.replace(':id', id),
                            type: 'DELETE',
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            success: function (res) {
                                Swal.fire('Terhapus!', res.message, 'success');
                                $('.data-table').DataTable().ajax.reload();
                            },
                            error: function (xhr) {
                                Swal.fire('Gagal!', 'Data gagal dihapus.', 'error');
                            }
                        });
                    }
                });
            });
        })
    </script>
@endpush
