<!DOCTYPE html>
<html>

<head>
    <title>TBM Report</title>
    <link rel="stylesheet" href="{{ public_path('font-awesome-4.7.0/css/font-awesome.min.css') }}">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        .table {
            table-layout: fixed;
            width: 100%;
        }

        .table td,
        .table th {
            word-wrap: break-word;
            overflow-wrap: break-word;
            padding: 5px;
            border: 1px solid #000;
        }

        /* table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    } */

        th,
        td {
            border: 1px solid black;
            text-align: start;
            padding: 8px;
        }

        th {
            background-color: #f2f2f2;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-left: 50%;
            margin-bottom: 20px;
        }

        .header h1 {
            margin: 0;
        }

        .notes {
            text-align: right;
        }

        .wrapper-page {
            page-break-after: always;
        }

        .wrapper-page:last-child {
            page-break-after: avoid;
        }
    </style>
</head>

<body>
    <div class="wrapper-page">
        <table style="width: 100%; border-collapse: collapse;" class="table">
            <tbody>
                <tr>
                    <td width="100%" class="text-left" style="padding-left:0px;border: none;">
                        <h2 style="margin: 0; padding-top: 8px;"><b>TBM Report
                                {{ \Carbon\Carbon::createFromFormat('m', date('m'))->format('F') }}
                                {{ date('Y') }}</b></h2>
                        <div>
                            {{-- TBM Report {{ \Carbon\Carbon::parse($stbm->date)->format('F Y') }} --}}
                        </div>

                    </td>
                    <td width="100%" style="text-align: right;border: none;">
                        <img style="width: 150px;" src="{{ public_path('images/pmm_logo_2.png') }}" alt="logo">
                    </td>
                </tr>
            </tbody>
        </table>
        {{-- <br />
        <br /> --}}
        <br />

        <table style="width: 100%; border-collapse: collapse; border: none; margin-top: 8px;">
            <tr>
                <td style="padding: 2px 0; border: none;">Operator</td>
                <td style="padding: 2px 4px; border: none; width: 5px;">:</td>
                <td style="padding: 2px 0; border: none;">{{ $stbm->user->name ?? '-' }}</td>
            </tr>
            <tr>
                <td style="padding: 2px 0; border: none;">Tanggal</td>
                <td style="padding: 2px 4px; border: none; width: 5px;">:</td>
                <td style="padding: 2px 0; border: none;">
                    {{ \Carbon\Carbon::parse($stbm->date)->format('d-m-Y H:i:s') }}
                </td>
            </tr>
            <tr>
                <td style="padding: 2px 0; border: none; font-weight: bold;">Site</td>
                <td style="padding: 2px 4px; border: none; width: 5px;">:</td>
                <td style="padding: 2px 0; border: none; font-weight: bold;">
                    {{ $stbm->location->name ?? '-' }}
                </td>
            </tr>
            <tr>
                <td style="padding: 2px 0; border: none; font-weight: bold;">Topik</td>
                <td style="padding: 2px 4px; border: none; width: 5px;">:</td>
                <td style="padding: 2px 0; border: none; font-weight: bold;">
                    {{ $stbm->topic ?? '-' }}
                </td>
            </tr>
        </table>




        {{-- <table>
            <tr>
                <th>No</th>
                <th>Name</th>
                <th>Lokasi</th>
                <th>Topic</th>
                <th>Keterangan</th>

                <th>Tanggal</th>

            </tr>

            @if (empty($stbm))
            <tr>
                <td colspan="{{ \Carbon\Carbon::createFromDate($year, $month, 1)->daysInMonth + 2 }}">Data Laporan
                    Kosong
                </td>
            </tr>
            @else
            <tr>
                <td style="vertical-align: top;">1</td>
                <td style="vertical-align: top;">{{ $stbm->user->name }}</td>
                <td style="vertical-align: top;">{{ $stbm->location->name }}</td>
                <td style="vertical-align: top;">{{ $stbm->topic }}</td>
                <td style="vertical-align: top;">{{ $stbm->description }}</td>
                <td style="vertical-align: top;">
                    {{ Helpers::formatDate(date: $stbm->date) }} {{
                    \Carbon\Carbon::parse($stbm->date)->format('H:i') }}
                </td>
            </tr>
            @endif
        </table> --}}
        {{-- <br> --}}
        <br>
        {{-- <br> --}}
        <h4 style="margin: 0; padding-top: 8px;"><b>Nama Peserta</b></h4>
        <br>
        <table>
            {{-- <tr>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
            </tr> --}}

            @if (empty($stbm->participant))
                <tr>
                    <td colspan="{{ \Carbon\Carbon::createFromDate($year, $month, 1)->daysInMonth + 2 }}">Data
                        peserta
                        kosong
                    </td>
                </tr>
            @else
                @php
                    $participants = $stbm->participant;
                    $cols = 4;
                    $rows = 5;
                @endphp
                @for ($row = 0; $row < $rows; $row++)
                    <tr>
                        @for ($col = 0; $col < $cols; $col++)
                            @php
                                $index = $row + $col * $rows; // rumus penting
                                $participant = $participants[$index]->name ?? '';
                            @endphp
                            <td style="vertical-align: top;font-size: 12px">
                                {{ $index + 1 }}.
                                @if ($participant)
                                    {{ $participant }}
                                @endif
                            </td>
                        @endfor
                    </tr>
                @endfor
            @endif
        </table>
        <br>
        <h4 style="margin: 0; padding-top: 8px;">Keterangan</h4>
        <br>
        <p style="font-size: 12px">{!! $stbm->description !!}</p>
    </div>

    <div class="wrapper-page">
        <h4 style="margin: 0; padding-top: 8px;">Dokumentasi</h4>
        <br>
        <table style="width: 100%; border-collapse: collapse;">
            @for ($i = 0; $i < count($stbm->images); $i += 2)
                <tr>
                    <td style="width: 50%; padding: 5px; text-align: center; vertical-align: top;border: none;">
                        <img src="{{ public_path('storage/' . $stbm->images[$i]->image) }}"
                            style="width: 100%; height: 450px; object-fit: cover; border: 1px solid #ddd;"
                            alt="">
                    </td>

                    @if (isset($stbm->images[$i + 1]))
                        <td style="width: 50%; padding: 5px; text-align: center; vertical-align: top;border: none;">
                            <img src="{{ public_path('storage/' . $stbm->images[$i + 1]->image) }}"
                                style="width: 100%; height: 350px; object-fit: cover; border: 1px solid #ddd;"
                                alt="">
                        </td>
                    @else
                        <td style="width: 50%; padding: 5px;border: none;"></td>
                    @endif
                </tr>
            @endfor
        </table>



    </div>



</body>

</html>
