<div class="modal fade" id="modalTambah" tabindex="-1" aria-labelledby="modalTambahRoleLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <form id="formTambah" enctype="multipart/form-data">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah TBM</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
                </div>
                <div class="modal-body">

                    <div class="row">
                        @php
                            $isAdmin = strtolower(auth()->user()->role->role) == 'admin';
                            $location_id = auth()->user()->location_id;
                        @endphp
                         <div class="col-md-6 col-12">
                            <div class="mb-3">
                                <label for="date" class="form-label">Tanggal</label>
                                <input type="datetime-local" name="date" id="date" required class="form-control"
                                    placeholder="Masukkan nama">
                            </div>
                        </div>
                        <div class="col-md-6 col-12">
                            <div class="mb-3">
                                <label for="location_id" class="form-label">Lokasi</label>
                                <select name="location_id" class="form-control lokasi">
                                    @foreach ($location as $l)
                                        <option {{ !$isAdmin && $location_id == $l ? 'selected' : '' }}
                                            value="{{ $l->id }}">
                                            {{ $l->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <div class="mb-3">
                        <label for="topic" class="form-label">Topik</label>
                        <textarea name="topic" class="form-control" rows="2" id="" required></textarea>
                    </div>
                      <div class="mb-3">
                        <label for="name" class="form-label">Safety Officer</label>
                        <input type="text" name="name" id="name" readonly value="{{ auth()->user()->name }}"
                            required class="form-control" placeholder="Masukkan nama">
                    </div>

                    <label for="description" class="form-label w-100">Peserta</label>
                    <div class="mb-3">
                            <div class="participant row g-4  mt-1">
                             @for ($i = 0; $i < 5; $i++)
                                 <div class="col-md-3 col-6 d-flex align-items-center g-2">
                                   <span>{{ $i+1 }}.</span> <div class="">
                                    <input type="text" name="participant[{{ $i }}]" class="form-control ms-2" value="" placeholder="Masukkan nama"id="" >

                                   </div>
                                 </div>
                                 <div class="col-md-3 col-6 d-flex align-items-center g-2">
                                   <span>{{ $i+1 + 5 }}.</span> <div class="">
                                    <input type="text" name="participant[{{ $i+ 5 }}]" class="form-control ms-2" value="" placeholder="Masukkan nama"id="" >
                                   </div>
                                 </div>
                                 <div class="col-md-3 col-6 d-flex align-items-center g-2">
                                   <span>{{ $i+1  + 10}}.</span> <div class="">
                                    <input type="text" name="participant[{{ $i+ 10}}]" class="form-control ms-2" value="" placeholder="Masukkan nama"id="" >
                                   </div>
                                 </div>
                                 <div class="col-md-3 col-6 d-flex align-items-center g-2">
                                   <span>{{ $i+1 + 15 }}.</span> <div class="">
                                    <input type="text" name="participant[{{ $i+ 15 }}]" class="form-control ms-2" value="" placeholder="Masukkan nama"id="" >
                                   </div>
                                 </div>
                            @endfor
                            </div>
                    </div>
                         <div class="mb-3">
                        <label for="description" class="form-label">Keterangan</label>
                        <textarea name="description" class="form-control " rows="3" id="keterangan-add" ></textarea>
                    </div>
                    <label for="description" class="form-label w-100">Dokumentasi</label>

                    <div class="mb-3">
                            <div class="images row g-4  mt-1">
                             @for ($i = 0; $i < 2; $i++)
                                 <div class="col-md-6 col-12 d-flex align-items-center g-2">
                                   <span>{{ $i+1 }}.</span>
                                   <div class="">
                                    <input type="file" name="images[{{ $i }}]" class="form-control ms-2" value="" placeholder="Masukkan nama"id="" accept="image/*"  >

                                   </div>
                                 </div>
                                 <div class="col-md-6 col-12 d-flex align-items-center g-2">
                                   <span>{{ $i+1 + 2 }}.</span> <div class="">
                                    <input type="file" name="images[{{ $i + 2 }}]" class="form-control ms-2" value="" placeholder="Masukkan nama"id="" accept="image/*"  >
                                   </div>
                                 </div>

                            @endfor
                            </div>
                    </div>
                    {{-- <div class="row">
                         <div class="col-md-6 col-12">
                            <label for="description" class="form-label w-100">Gambar</label>
                            <div class="images d-flex flex-column gap-2"></div>
                            <button type="button" class="btn btn-primary mt-4 add-image"><i
                                    class="fa fa-plus"></i></button>
                        </div>
                    </div> --}}
                    <div class="deleted-images"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </div>
        </form>
    </div>
</div>


@push('extraJS')
    <script>
        $(document).ready(function() {
            let  editor ;
             ClassicEditor
            .create(document.querySelector("#keterangan-add"))
            .then(ed => {
                editor = ed
            })
            .catch(error => console.error('❌ CKEditor error:', error));

            $('#formTambah').on('submit', function(e) {
                e.preventDefault();

                const form = $(this);
                const formData = new FormData(this);
                formData.append("description",editor.getData())
                $("#formTambah").find("[name*='participant']")



                $.ajax({
                    url: '{{ route('stbm.store') }}',
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        $('#modalTambah').modal('hide');
                        form.trigger("reset");

                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        });

                        $('.data-table').DataTable().ajax.reload();
                    },
                    error: function(xhr) {
                        let message = xhr.responseJSON?.message || 'Terjadi kesalahan';
                        // Swal.fire({
                        //     icon: 'error',
                        //     title: 'Gagal Menyimpan',
                        //     text: message
                        // });
                        console.log(xhr);
                        handleValidationErrors(xhr, form);

                    }
                });
            });

        })
    </script>
@endpush
