<!DOCTYPE html>
<html>

<head>
    <title>Monthly Report</title>
    <link rel="stylesheet" href="{{ public_path('font-awesome-4.7.0/css/font-awesome.min.css') }}">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        .table {
            table-layout: fixed;
            width: 100%;
        }

        .table td,
        .table th {
            word-wrap: break-word;
            overflow-wrap: break-word;
            padding: 5px;
            border: 1px solid #000;
        }

        /* table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    } */

        th,
        td {
            border: 1px solid black;
            text-align: start;
            padding: 8px;
        }

        th {
            background-color: #f2f2f2;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-left: 50%;
            margin-bottom: 20px;
        }

        .header h1 {
            margin: 0;
        }

        .notes {
            text-align: right;
        }
    </style>
</head>

<body>
    <table style="width: 100%; border-collapse: collapse;" class="table">
        <tbody>
            <tr>
                <td width="100%" class="text-left" style="padding-left:40px;">
                    <h1 style="margin: 0; padding-top: 8px;"><b>{{ $equipment->unit_code }}</b></h1>
                    <div>
                        {{ $equipment->serial_number_unit }}
                    </div>
                </td>
                <td width="100%" style="text-align: right;">
                    <img style="width: 150px;" src="{{ public_path('images/logo.jpg') }}" alt="logo">
                </td>
            </tr>
            <tr>
                <td>
                    <div style="padding-top: 25px;" class="table">
                        <table style="border-collapse: collapse;" class="table">
                            <tbody class="text-left">
                                <tr class="text-left">
                                    <td class="text-left"><b>Monthly Report # :
                                            {{ \Carbon\Carbon::createFromFormat('m', $month)->format('F') }}
                                            {{ $year }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-left">Unit Name : - {{ $equipment->unittype->name }}</td>
                                </tr>
                                <tr>
                                    <td class="text-left">Unit # : {{ $equipment->unit_code }}</td>
                                </tr>
                                <tr>
                                    <td class="text-left">Pdf di buat pada # : {{ date('Y-m-d H:i:s') }} </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- <div class="header">
        <div>
            <h1>Bulan: {{ \Carbon\Carbon::createFromFormat('m', $month)->format('F') }} {{ $year }}</h1>
            <h1>Unit: {{ $equipment->code_unit }}</h1>
            <h1>Shift: {{ $shift->name }}</h1>
        </div>
        <div class="notes">
            <p>Notes:</p>
            <p> <i class="fa fa-check-circle-o text-success" aria-hidden="true" style="font-size: 20px"></i> = OK</p>
            <p><i class="fa fa-times-circle-o text-danger" aria-hidden="true" style="font-size: 20px"></i> = Rusak</p>
            <p> <i class="fa fa-circle-o text-warning" aria-hidden="true" style="font-size: 20px"></i> = Layak
                Pakai</p>
        </div>
    </div> -->

    <table>
        <tr>
            <th>No</th>
            <th>Form Item</th>
            @for ($i = 1; $i <= \Carbon\Carbon::createFromDate($year, $month, 1)->daysInMonth; $i++)
                <th>{{ $i }}</th>
            @endfor
        </tr>

        @if (empty($formItemsStatus))
            <tr>
                <td colspan="{{ \Carbon\Carbon::createFromDate($year, $month, 1)->daysInMonth + 2 }}">Data Laporan Pada
                    Filter Bulan,Shift dan Equipment ini kosong</td>
            </tr>
        @else
            @foreach ($formItemsStatus as $formItemName => $statuses)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $formItemName }}</td>
                    @for ($i = 1; $i <= \Carbon\Carbon::createFromDate($year, $month, 1)->daysInMonth; $i++)
                        <td style="text-align: center !important;">
                            @php $day = str_pad($i, 2, '0', STR_PAD_LEFT); @endphp
                            @if (isset($statuses[$day]))
                                @if ($statuses[$day] == 'Baik')
                                    <!-- Centang hijau -->
                                    <i class="fa fa-check-circle-o" aria-hidden="true" style="color:green; font-size:20px;"></i>
                                @elseif ($statuses[$day] == 'Rusak')
                                    <!-- Silang merah -->
                                    <i class="fa fa-times-circle-o" aria-hidden="true" style="color:red; font-size:20px;"></i>
                                @elseif ($statuses[$day] == 'Cukup')
                                    <!-- Centang kuning -->
                                    <i class="fa fa-check-circle-o" aria-hidden="true" style="color:#FFDE21; font-size:20px;"></i>
                                @elseif ($statuses[$day] == 'N/A')
                                    <!-- Silang hitam -->
                                    <i class="fa fa-times-circle-o" aria-hidden="true" style="color:black; font-size:20px;"></i>
                                @else
                                    -
                                @endif
                            @else
                                -
                            @endif
                        </td>
                    @endfor
                </tr>
            @endforeach
        @endif
    </table>

    <table class="text-center" style="padding-top:20px; border: 1px solid #000; width: 20%">
        <tr style="border: 1px solid #000">
            <td colspan="3" style="border: 1px solid #000;font-size:13px; background-color: #b6b6b6;">Catatan</td>
        </tr>
        <tr>
            <td colspan="1" style="border: 1px solid #000;font-size:13px;text-align:center !important">
                <i class="fa fa-check-circle-o text-success" aria-hidden="true" style="color:green;font-size: 20px"></i>

            </td>
            <td colspan="2" style="text-align:center !important;border: 1px solid #000;font-size:13px;">Baik</td>
        </tr>
        <tr>
            <td colspan="1" style="border: 1px solid #000;font-size:13px;text-align:center !important">
                <i class="fa fa-times-circle-o text-danger" aria-hidden="true" style="color:red;font-size: 20px"></i>

            </td>
            <td colspan="2" style="text-align:center !important;border: 1px solid #000;font-size:13px;">Rusak</td>
        </tr>
        <tr>
            <td colspan="1" style="border: 1px solid #000;font-size:13px;text-align:center !important">
                <i class="fa fa-times-circle-o text-warning" aria-hidden="true"
                    style="color:#FFDE21;font-size: 20px"></i>

            </td>
            <td colspan="2" style="text-align:center !important;border: 1px solid #000;font-size:13px;">Cukup
            </td>
        </tr>
        <tr>
            <td colspan="1" style="border: 1px solid #000;font-size:13px;text-align:center !important">
                -
            </td>
            <td colspan="2" style="text-align:center !important;border: 1px solid #000;font-size:13px;">NA (Not
                Applicable)</td>
        </tr>
        <tr>
            <td colspan="1" style="border: 1px solid #000;font-size:13px;text-align:center !important">
                -
            </td>
            <td colspan="2" style="text-align:center !important;border: 1px solid #000;font-size:13px;">NI (Not
                Isnpected)</td>
        </tr>
    </table>
    <!-- <div class="row">
        <div class="mt-10" style="bottom:0px; right:0px; position: absolute; ">
            <div class="font-weight-bold"> {{ date('Y-m-d H:i:s') }}</div>
        </div>
    </div> -->


</body>

</html>
