<div class="modal fade" id="modal" tabindex="-1" aria-labelledby="modalTambahShiftLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="form">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fw-bold">Monthly Inspection</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
                </div>

                <div class="modal-body">

                    <!-- Nama Shift -->
                    <div class="mb-3">
                        <label for="shift_id" class="form-label fw-semibold">Tahun</label>
                        <select class="form-select select2-year" name="year" id="year">
                            @php
                                $currentYear = now()->year;
                                $startYear = $currentYear - 10;
                                $endYear = $currentYear;
                            @endphp

                            @for ($y = $startYear; $y <= $endYear; $y++)
                                <option value="{{ $y }}" {{$y == $currentYear ? "selected" : ""}} {{ $y == $currentYear ? 'selected' : '' }}>
                                    {{ $y }}
                                </option>
                            @endfor
                        </select>

                    </div>
                    <div class="mb-3">
                        <label for="month" class="form-label fw-semibold">Bulan</label>
                        <select name="month" class="form-select " id="month">
                            <option value="">- Pilih -</option>
                            @php
                                $months = [
                                    1 => 'Januari',
                                    2 => 'Februari',
                                    3 => 'Maret',
                                    4 => 'April',
                                    5 => 'Mei',
                                    6 => 'Juni',
                                    7 => 'Juli',
                                    8 => 'Agustus',
                                    9 => 'September',
                                    10 => 'Oktober',
                                    11 => 'November',
                                    12 => 'Desember',
                                ];
                            @endphp

                            @foreach ($months as $num => $name)
                                <option value="{{ $num }}" {{ old('month', request('month')) == $num ? 'selected' : '' }}>
                                    {{ $name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <input type="hidden" name="unitId" id="unitId">
                    <div class="mb-3">
                        <label for="shift_id" class="form-label fw-semibold">Shift</label>
                        <select name="shift_id" class="form-select shift" id="shift">
                            <option value="">- Pilih -</option>
                            @foreach ($shift as $item)
                                <option value="{{ $item->id }}">Shift - {{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-primary">Cetak PDF</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('extraJS')
    <script>
        $(document).ready(function () {
            $(" #modalTambah .shift").select2({
                dropdownParent: $('#modalTambah'),
                width: '100%',
                allowClear: true,
                theme: "bootstrap",
                placeholder: "Pilih Shift"
            })


            $('#form').on('submit', function (e) {
                e.preventDefault();
                const shift = $("#shift").val();
                const unitId = $("#unitId").val();
                const year = $("#year").val();
                const month = $("#month").val();
                console.table(shift, unitId, year, month);
                // pastikan semua value sudah diisi sebelum lanjut
                if (!shift || !unitId || !year || !month) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Semua field harus diisi',
                        confirmButtonColor: '#3085d6'
                    }); return;
                }

                // bentuk URL sesuai urutan parameter di route
                // const url = `/monthly / ${ unitId } /${month}/${ year } /${shift}/pdf`;
                const url = `{{ route('monthly.pdf', [':unitId', ':month', ':year', ':shift']) }}`
                    .replace(':unitId', unitId)
                    .replace(':month', month)
                    .replace(':year', year)
                    .replace(':shift', shift);
                // buka PDF di tab baru
                window.open(url, "_blank");

                $(`#modal`).modal(`hide`);
            });

        });
    </script>
@endpush
