@extends('template.master')
{{-- modal --}}

{{-- modal --}}
@section('content')
    <form action="{{ route('daily-report.update', $daily->id) }}" method="POST">
        @csrf
        @method('PUT')
        <style>
            .accordion-button:not(.collapsed) {
                background-color: white;
            }

            .accordion-button::after {
                display: none !important;
            }
        </style>

        <div class="container">
            <h5><strong>History Daily Report,</strong> {{ $daily->form->title ?? '' }} </h5>
            <hr>

            <div class="accordion" id="accordionExample">
                @foreach ($daily->form->sections as $index => $section)
                    <div class="accordion-item shadow-sm mb-2">
                        <h2 class="accordion-header border border-b">
                            <div class="d-flex justify-content-between align-items-center w-100 pe-4">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#section-{{ $index }}" aria-expanded="false"
                                    aria-controls="section-{{ $index }}">
                                    <h5 class="mb-0"><strong>{{ $section->name }}</strong></h5>
                                </button>
                            </div>
                        </h2>

                        <div id="section-{{ $index }}" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <div class="table-responsive">
                                    <table class="table table-hover table-striped table-condensed table-bordered table-sm">
                                        <thead>
                                            <tr>
                                                <th>Inspection Item</th>
                                                <th>Catatan</th>
                                                @foreach ($status as $item)
                                                    <th class="text-center">{{ $item->name }}</th>
                                                @endforeach
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($section->items as $key => $item)
                                                @php
                                                    $currentDailyItem = $daily->detail->firstWhere(
                                                        'forms_items_id',
                                                        $item->id,
                                                    );
                                                    $statusItem = $item->status->pluck("name")->toArray();
                                                @endphp
                                                <tr>
                                                    <input type="hidden" name="forms_items_id[{{ $index }}][{{ $key }}]"
                                                        value="{{ $item->id }}">

                                                    <td>{{ $item->name }}</td>

                                                    <td style="width: 30%">
                                                        <input type="text" name="catatan[{{ $index }}][{{ $key }}]"
                                                            class="form-control" value="{{ $currentDailyItem->catatan ?? '' }}">
                                                    </td>

                                                    @foreach ($status as $statusKey => $stTd)
                                                        @php
                                                            $isChecked = optional($currentDailyItem)->status == $stTd->name;
                                                        @endphp
                                                        <td class="text-center">
                                                            <input required type="radio" class="btn-check"
                                                                name="status[{{ $index }}][{{ $key }}]"
                                                                id="status-{{ $index }}-{{ $key }}-{{ $statusKey }}" value="{{ $stTd->id }}"
                                                                {{ $isChecked ? 'checked' : '' }}>
                                                            @if ($stTd->name === 'Baik' && in_array("Baik", $statusItem))
                                                                <label class="btn btn-outline-success"
                                                                    for="status-{{ $index }}-{{ $key }}-{{ $statusKey }}">{{ $stTd->name }}</label>
                                                            @elseif($stTd->name === 'Rusak' && in_array("Rusak", $statusItem))
                                                                <label class="btn btn-outline-danger"
                                                                    for="status-{{ $index }}-{{ $key }}-{{ $statusKey }}">{{ $stTd->name }}</label>
                                                            @elseif($stTd->name === 'Layak Pakai' && in_array("Layak Pakai", $statusItem))
                                                                <label class="btn btn-outline-warning"
                                                                    for="status-{{ $index }}-{{ $key }}-{{ $statusKey }}">{{ $stTd->name }}</label>
                                                            @elseif($stTd->name === 'Tidak Tersedia' && in_array("Tidak Tersedia", $statusItem))
                                                                <label class="btn btn-outline-primary"
                                                                    for="status-{{ $index }}-{{ $key }}-{{ $statusKey }}">{{ $stTd->name }}</label>
                                                            @endif
                                                        </td>
                                                    @endforeach
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            {{-- Note Tambahan --}}
            <div class="col-lg-12 mt-4">
                <div class="form-group mb-3">
                    <textarea name="downtime_note" id="downtime_note" class="form-control" cols="30" rows="5"
                        placeholder="Note">{{ $daily->downtime_note ?? '' }}</textarea>
                </div>
            </div>
            <div class="d-flex justify-content-between">
                <div>
                    <button type="submit" class="btn btn-primary">Lanjutkan</button>
                </div>
            </div>
        </div>
    </form>
@endsection
@push('extraJS')
@endpush
