@extends('template.master')
{{-- modal --}}

{{-- modal --}}
@section('content')
    @if ($canCreate)
        <x-primary-button data-bs-toggle="modal" data-bs-target="#modalTambah" class="mb-4">Tambah Status</x-primary-button>
    @endif

    <div class="card">
        <div class="card-body">
            <table id="activeTable" class="table table-striped data-table">
                <thead>
                    <tr>
                        <th id="no">No</th>
                        <th>Status</th>
                        <th width="105px">Action</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>


    @include('master-data.status.modal.add')
    @include('master-data.status.modal.edit')
@endsection
@push('extraJS')
    <script type="text/javascript">
        $(document).ready(function () {
            $(function () {
                var table = $('#activeTable').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('status-checklist.index') }}",
                        data: function (d) {
                            d.option = "active";
                        },
                    },
                    columnDefs: [{
                        width: "50px",
                        targets: 0
                    } // 0 adalah index kolom 'id'
                    ],
                    columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        className: 'text-center',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                    ]
                });

            });

            // tambah
            $('#formTambah').on('submit', function (e) {
                e.preventDefault();
                const form = $(this);
                const name = $('#status').val().trim();
                if (!name) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Validasi Gagal',
                        text: 'Nama status wajib diisi.'
                    });
                    return;
                }

                $.ajax({
                    url: '{{ route('status-checklist.store') }}',
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: form.serialize(),
                    success: function (response) {
                        $('#modalTambah').modal('hide');
                        form.trigger("reset");

                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        });

                        $('.data-table').DataTable().ajax.reload();
                    },
                    error: function (xhr) {
                        let message = xhr.responseJSON?.message || 'Terjadi kesalahan';
                        Swal.fire({
                            icon: 'error',
                            title: 'Gagal Menyimpan',
                            text: message
                        });
                    }
                });
            });

            // edit
            $(document).on('click', '.edit', function () {
                let id = $(this).data('id');
                let name = $(this).data('name');
                let actions = $(this).data('actions');

                $('#edit-id').val(id);
                $('#edit-name').val(name);
                $('#modalEdit').modal('show');
            });

            // Handle form submit edit
            $('#formEdit').on('submit', function (e) {
                e.preventDefault();
                const form = $(this);

                let id = $('#edit-id').val();
                let name = $('#edit-name').val().trim();

                if (!name) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Validasi Gagal',
                        text: 'Nama status wajib diisi.'
                    });
                    return;
                }

                $.ajax({
                    url: `{{ route('status-checklist.update', ':id') }}`.replace(':id', id),
                    type: 'PUT',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: form.serialize(),
                    success: function (response) {
                        $('#modalEdit').modal('hide');

                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        });

                        $('.data-table').DataTable().ajax.reload();
                    },
                    error: function (xhr) {
                        let message = xhr.responseJSON?.message || 'Terjadi kesalahan saat update.';
                        Swal.fire({
                            icon: 'error',
                            title: 'Gagal Update',
                            text: message
                        });
                    }
                });
            });
            // delete
            $(document).on("click", ".delete", function () {
                var id = $(this).data("id");

                Swal.fire({
                    title: 'Apakah kamu yakin?',
                    text: "Data akan dihapus secara permanen!",
                    icon: 'warning',
                    showCancelButton: true,
                    cancelButtonColor: '#3085d6',
                    confirmButtonColor: '#d33',
                    confirmButtonText: 'Ya, hapus!',
                    cancelButtonText: 'Batal'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: `{{ route('status-checklist.destroy', ":id") }}`.replace(":id", id),
                            type: 'DELETE',
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            success: function (res) {
                                Swal.fire('Terhapus!', res.message, 'success');
                                $('.data-table').DataTable().ajax.reload();
                            },
                            error: function (xhr) {
                                Swal.fire('Gagal!', 'Data gagal dihapus.', 'error');
                            }
                        });
                    }
                });
            });
        })
    </script>
@endpush
