@extends('template.master')

@section('content')
    <div class="row">
        <div class="card">
            <div class="card-body">
                <table id="datatable" class="table table-striped data-table">
                    <thead>
                        <tr>
                            <th id="no">No</th>
                            <th>Nama</th>
                            <th>Email</th>
                            <th>Username</th>
                            <th>Sites</th>
                            <th>Role</th>
                            <th width="105px">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@push('extraJS')
    <script type="text/javascript">
        $(function () {
            var table = $('#datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('aprrove.index') }}",
                    error: function (d) {
                        console.log(d);
                    }
                },
                columnDefs: [{
                    width: "50px",
                    targets: 0
                } // 0 adalah index kolom 'id'
                ],
                columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    className: 'text-center',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'email',
                    name: 'email'
                },
                {
                    data: 'username',
                    name: 'username'
                },
                {
                    data: 'sites',
                    name: 'sites'
                },
                {
                    data: 'role',
                    name: 'role'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                },
                ]
            });
        });

        $(document).on('click', '.btn-approve', function () {
            const userId = $(this).data('id');

            Swal.fire({
                title: 'Persetujuan Akun',
                text: "Apakah akun ini ingin disetujui atau ditolak?",
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Setujui ✅',
                cancelButtonText: 'Tolak ❌',
                reverseButtons: true,
            }).then((result) => {
                let approveStatus = null;

                if (result.isConfirmed) {
                    approveStatus = 'setuju';
                } else if (result.dismiss === Swal.DismissReason.cancel) {
                    approveStatus = 'tidak';
                }

                if (approveStatus) {
                    $.ajax({
                        url: "{{ url('/aprrove') }}/" + userId,
                        type: 'PUT',
                        data: {
                            _token: '{{ csrf_token() }}',
                            approve: approveStatus
                        },
                        success: function (res) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Berhasil!',
                                text: res.message,
                                timer: 1500,
                                showConfirmButton: false
                            });

                            $('.data-table').DataTable().ajax.reload();
                        },
                        error: function (err) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Oops...',
                                text: 'Terjadi kesalahan saat memperbarui data.'
                            });
                        }
                    });
                }
            });
        });
    </script>
@endpush
