@extends('template.master')
{{-- modal --}}

{{-- modal --}}
@section('content')
    <x-primary-button data-bs-toggle="modal" data-bs-target="#modalTambahAction">Tambah Action</x-primary-button>
    <table class="table table-striped data-table">
        <thead>
            <tr>
                <th id="no">No</th>
                <th>Nama Action</th>
                <th>Base URL</th>
                <th width="105px">Action</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>


    @include('master-data.action.modal.add')
    @include('master-data.action.modal.edit')
@endsection

@push('extraJS')
    <script type="text/javascript">
        $(function () {
            var table = $('.data-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('actions.index') }}",
                columnDefs: [{
                    width: "50px",
                    targets: 0
                } // 0 adalah index kolom 'id'
                ],
                columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    className: 'text-center',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'base_url',
                    name: 'base_url'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                },
                ]
            });

        });

        // tambah
        $('#formTambahAction').on('submit', function (e) {
            e.preventDefault();

            const form = $(this);
            const name = $('#name').val().trim();
            const base_url = $('#base_url').val().trim();

            if (!name) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Validasi Gagal',
                    text: 'Nama role wajib diisi.'
                });
                return;
            }
            if (!base_url) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Validasi Gagal',
                    text: 'Base URL wajib diisi.'
                });
                return;
            }

            $.ajax({
                url: '{{ route('actions.store') }}',
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: form.serialize(),
                success: function (response) {
                    $('#modalTambahAction').modal('hide');
                    form.trigger("reset");

                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil!',
                        text: response.message,
                        timer: 2000,
                        showConfirmButton: false
                    });

                    $('.data-table').DataTable().ajax.reload();
                },
                error: function (xhr) {
                    console.log(xhr);
                    let message = xhr.responseJSON?.message || 'Terjadi kesalahan';
                    Swal.fire({
                        icon: 'error',
                        title: 'Gagal Menyimpan',
                        text: message
                    });
                }
            });
        });

        // edit
        $(document).on('click', '.edit', function () {
            let id = $(this).data('id');
            let name = $(this).data('name');
            let base_url = $(this).data('base_url');
            let parent_name = $(this).data('parent_name');

            $('#edit-id').val(id);
            $('#edit-name').val(name);
            $('#edit-base_url').val(base_url);
            $('#edit_parent_name').val(parent_name);
            $('#modalEditAction').modal('show');
        });

        // Handle form submit edit
        $('#formEditAction').on('submit', function (e) {
            e.preventDefault();

            let id = $('#edit-id').val();
            let name = $('#edit-name').val().trim();
            let base_url = $('#edit-base_url').val().trim();
            let parent_menu = $('#edit_parent_name').val().trim();

            if (!name) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Validasi Gagal',
                    text: 'Nama action wajib diisi.'
                });
                return;
            }
            if (!base_url) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Validasi Gagal',
                    text: 'Base url wajib diisi.'
                });
                return;
            }
            if (!parent_menu) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Validasi Gagal',
                    text: 'Kelompok action wajib diisi.'
                });
                return;
            }


            $.ajax({
                url: `{{ route('actions.update', ":id") }}`.replace(":id", id),
                type: 'PUT',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    name: name,
                    base_url: base_url,
                    parent_menu: parent_menu
                },
                success: function (response) {
                    $('#modalEditAction').modal('hide');

                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil!',
                        text: response.message,
                        timer: 2000,
                        showConfirmButton: false
                    });

                    $('.data-table').DataTable().ajax.reload();
                },
                error: function (xhr) {
                    let message = xhr.responseJSON?.message || 'Terjadi kesalahan saat update.';
                    Swal.fire({
                        icon: 'error',
                        title: 'Gagal Update',
                        text: message
                    });
                }
            });
        });
        // delete
        $(document).on("click", ".delete", function () {
            var id = $(this).data("id");

            Swal.fire({
                title: 'Apakah kamu yakin?',
                text: "Data akan dihapus secara permanen!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: `{{ route('actions.destroy', ":id") }}`.replace(":id", id),
                        type: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function (res) {
                            Swal.fire('Terhapus!', res.message, 'success');
                            $('.data-table').DataTable().ajax.reload();
                        },
                        error: function (xhr) {
                            Swal.fire('Gagal!', 'Data gagal dihapus.', 'error');
                        }
                    });
                }
            });
        });
    </script>
@endpush
