@extends('template.master')

@section('content')
    <div class="row">
        @php
            $colors = ['primary', 'secondary', 'danger', 'warning'];
        @endphp

        @foreach ($equipmentStats as $index => $stat)
            <div class="col-lg-3 mb-3">
                <div class="card bg-{{ $colors[$index % count($colors)] }}">
                    <div class="card-body">
                        <div class="card-text">
                            <h6 class="text-white">Total Unit {{ $stat->type_name }}</h6>
                            <h3 class="text-white">{{ $stat->total_equipment }}</h3>
                            <h6 class="text-white">Jumlah Unit {{ $stat->type_name }}.</h6>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <div class="container">
        <!-- Tabs Sites -->
        <ul class="nav nav-tabs" id="siteTabs" role="tablist">
            @foreach ($sites as $site)
                <li class="nav-item">
                    <button class="nav-link @if ($loop->first) active @endif" data-bs-toggle="tab"
                        data-bs-target="#site-{{ Str::slug($site->id) }}">
                        {{ $site->name }}
                    </button>
                </li>
            @endforeach
            <li class="nav-item ms-auto">
                <form action="" method="get">
                    <input type="date" onchange="this.form.submit()" class="form-control"
                        value="{{ request()->tanggal }}" name="tanggal" id="">
                </form>
            </li>
        </ul>

        <!-- Content per Site -->
        <div class="tab-content mt-3">
            @foreach ($sites as $site)
                <div class="tab-pane fade @if ($loop->first) show active @endif"
                    id="site-{{ Str::slug($site->id) }}">
                    @foreach ($site->shifts() as $shift)
                        <div class="card mb-3">
                            <div class="card-header">
                                Shift - {{ $shift->name }}
                            </div>
                            <div class="card-body d-flex gap-4 flex-wrap">
                                @foreach ($site->units->sortBy(function ($item) {
                                    if (Str::startsWith($item->unit_code, 'L-')) {
                                        return 1;
                                    }
                                    if (Str::startsWith($item->unit_code, 'E-')) {
                                        return 2;
                                    }
                                    if (Str::startsWith($item->unit_code, 'DT-')) {
                                        return 3;
                                    }
                                    if (Str::startsWith($item->unit_code, 'S-')) {
                                        return 4;
                                    }
                                    return 5;
                                }) as $item)
                                    @php
                                        $status =
                                            $groupedBySiteShift[$item->id . '_' . $shift->id]->status_checklist ??
                                            'Belum Checklist';
                                        $map = [
                                            'Baik' => ['color' => '#007bff'],
                                            'Cukup' => ['color' => '#fd7e14'],
                                            'Rusak' => ['color' => '#DD0303'],
                                            'Rusak Fatal' => ['color' => '#6c757d'],
                                            'Belum Checklist' => ['color' => ''],
                                            'N/A' => ['color' => '#6c757d'],
                                        ];

                                        $color = $map[$status]['color'];
                                        $label = $status;

                                        $imagePath = $item->unittype->image
                                            ? asset($item->unittype->image)
                                            : asset('images/default-icon.png'); // icon hitam default
                                    @endphp

                                    <div class="text-center">
                                        <div>{{ $item->unit_code ?? 'Unknown' }}</div>
                                        <div
                                            style="
                                                width: 100px;
                                                height: 100px;
                                                position: relative;
                                                border-radius: 8px;
                                                background-color: {{ $color }};
                                                display: flex;
                                                align-items: center;
                                                justify-content: center;
                                                overflow: hidden;
                                            ">
                                            <img src="{{ $imagePath }}" alt="{{ $item->unit_code }}"
                                                style="
                                                max-width: 70%;
                                                max-height: 70%;
                                                object-fit: contain;
                                                position: absolute;
                                                z-index: 2;
                                            ">
                                        </div>
                                        <strong>{{ $label }}</strong>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                </div>
            @endforeach

        </div>
    </div>
@endsection

@push('extraJS')
@endpush
