<!DOCTYPE html>
<html>

<head>
    <title>Daily Report - {{ $daily->code_report }}</title>
    <link rel="stylesheet" href="{{ public_path('font-awesome-4.7.0/css/font-awesome.min.css') }}">
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 11px;
        }

        h1,
        h2,
        h3 {
            margin: 0;
            padding: 0;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            border-bottom: 2px solid #000;
            padding-bottom: 5px;
            margin-bottom: 10px;
        }

        .header-left {
            width: 70%;
        }

        .header-left h1 {
            font-size: 18px;
            font-weight: bold;
        }

        .header-left p {
            margin: 2px 0;
        }

        .header-right {
            width: 100%;
            text-align: right;
        }

        .header-right img {
            width: 70px;
        }

        .report-info {
            margin-top: 10px;
            margin-bottom: 10px;
        }

        .report-info table {
            width: 100%;
            border-collapse: collapse;
        }

        .report-info td {
            padding: 2px 5px;
            vertical-align: top;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        .table th,
        .table td {
            border: 1px solid #000;
            padding: 0px 4px;
        }

        .table th {
            background: #f3f3f3;
        }

        .text-left {
            text-align: left;
        }

        .text-center {
            text-align: center;
        }

        .no-border {
            border: none !important;
        }
    </style>
</head>

<body>
    <table style="width: 100%; border-bottom: 2px solid #000; margin-bottom: 10px;">
        <tr>
            <td style="width: 70%; vertical-align: top;">
                <h1 style="font-size: 18px; font-weight: bold; margin: 0;">{{ $daily->form->title }}</h1>
                <p style="margin: 3px 0 0 0;">
                    Checklist unit operator untuk {{ $daily->unit->unittype->name }} per hari
                </p>
            </td>
            <td style="width: 30%; text-align: right; vertical-align: top;">
                <img src="{{ public_path('images/logo.jpg') }}" style="width: 120px;" alt="logo">
            </td>
        </tr>
    </table>


    <div class="report-info">
        <table>
            <tr>
                <td><strong>Report # :</strong></td>
                <td>{{ $daily->code_report }}</td>
            </tr>
            <tr>
                <td><strong>Unit Name :</strong></td>
                <td>{{ $unit->unittype->name }}</td>
            </tr>
            <tr>
                <td><strong>Unit # :</strong></td>
                <td>{{ $unit->unit_code }}</td>
            </tr>
            <tr>
                <td><strong>Shift :</strong></td>
                <td>Shift {{ $daily->shift->name }}</td>
            </tr>
            {{-- <tr>
                <td><strong>Vin # :</strong></td>
                <td>-</td>
            </tr> --}}
        </table>
    </div>

    @php
        use Carbon\Carbon;

        $now = Carbon::now('Asia/Jakarta')->locale('id');
        $no = 1;
        $days = ['Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab', 'Min'];
        $currentDayIndex = $now->dayOfWeekIso - 1;
    @endphp

    {{-- TABEL HARI --}}
    <table class="table table-bordered"
        style="width: 100%; text-align:center; border-collapse: collapse; font-size: 12px;">
        <tbody>
            <tr>
                <td style="background-color: #e0e0e0; font-weight:bold; width: 100px;">Hari</td>
                @foreach ($days as $day)
                    <td>{{ $day }}</td>
                @endforeach
            </tr>
            <tr>
                <td style="background-color: #e0e0e0; font-weight:bold;">Tanggal & Jam</td>
                @foreach ($days as $i => $day)
                    <td>
                        @if ($i === $currentDayIndex)
                            {{ $now->translatedFormat('d-F-Y H:i:s') }}
                        @endif
                    </td>
                @endforeach
            </tr>
            {{-- <tr>
                <td style="background-color: #e0e0e0; font-weight:bold;">Meter Reading</td>
                @foreach ($days as $i => $day)
                <td>
                    @if ($i === $currentDayIndex)
                    {{ $daily->meter_reading ?? '0 Hours' }}
                    @endif
                </td>
                @endforeach
            </tr> --}}
        </tbody>
    </table>

    <table class="table" style="margin-top: 10px;">
        <thead>
            <tr>
                <th>SN</th>
                <th class="text-left">Keseluruhan Unit</th>
                @foreach ($status as $item)
                    <th>{{ $item->name }}</th>
                @endforeach
                <th>Catatan</th>
            </tr>
        </thead>
        <tbody>

            @foreach ($daily->form->sections as $index => $section)
                @foreach ($section->items as $key => $item)
                    @php
                        $currentDailyItem = $daily_item->firstWhere('form_item_id', $item->id);
                    @endphp
                    <tr>
                        <td>{{ $no++ }}</td>
                        <td>{{ $item->name }}</td>

                        @foreach ($status as $st)
                            <td style="text-align:center;">
                                @if ($currentDailyItem && $currentDailyItem->status_id == $st->id)
                                    @php
                                        $color = '#000000';
                                        if ($st->name == 'Baik') {
                                            $color = 'green';
                                        } elseif ($st->name == 'Rusak') {
                                            $color = 'red';
                                        } elseif ($st->name == 'Cukup') {
                                            $color = '#FFDE21';
                                        }
                                    @endphp
                                    <span style="color:{{ $color }};font-size:12px">✔</span>
                                @endif
                            </td>
                        @endforeach

                        <td>{{ $currentDailyItem->note ?? '' }}</td>
                    </tr>
                @endforeach
            @endforeach

        </tbody>
        <tfoot>
            @php
                $count = $status->count();
            @endphp
            <tr>
                <td colspan="2" style="text-align: left;">Comment (*)</td>
                <td colspan="{{ $count + 1 }}">{{ $daily->comment }}</td>
            </tr>
        </tfoot>
    </table>

    {{-- TABEL OPERATOR / SHIFT / COMMENT --}}
    <table class="table table-bordered"
        style="width: 100%; text-align:center; border-collapse: collapse; font-size: 12px; margin-top: 5px;">
        <tbody>
            <tr>
                <td style="background-color: #e0e0e0; font-weight:bold; width: 100px;">Operator</td>
                @foreach ($days as $i => $day)
                    <td>
                        @if ($i === $currentDayIndex)
                            {{ $daily->user->name ?? '-' }}
                        @endif
                    </td>
                @endforeach
            </tr>
            <tr>
                <td style="background-color: #e0e0e0; font-weight:bold;">Shift</td>
                @foreach ($days as $i => $day)
                    <td>
                        @if ($i === $currentDayIndex)
                            Shift - {{ $daily->shift->name ?? '-' }}
                        @endif
                    </td>
                @endforeach
            </tr>
        </tbody>
    </table>

    {{-- @dd("halo") --}}
</body>

</html>
