@extends('template.master')
{{-- modal --}}

{{-- modal --}}
@section('content')
    <form novalidate action="{{ route('daily-report.update', $daily->id) }}" method="POST">
        @csrf
        @method('PUT')
        <style>
            .accordion-button:not(.collapsed) {
                background-color: white;
            }

            .accordion-button::after {
                display: none !important;
            }
        </style>

        <div class="container">
            <h5><strong>History Daily Report,</strong> {{ $daily->form->title ?? '' }} </h5>
            <hr>

            <div class="accordion" id="accordionExample">
                @foreach ($daily->form->sections as $index => $section)
                    @if (count($section->items) == 0)
                        @continue
                    @endif
                    <div class="accordion-item shadow-sm mb-2">
                        <h2 class="accordion-header border border-b">
                            <div class="d-flex justify-content-between align-items-center w-100 pe-4">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#section-{{ $index }}" aria-expanded="false"
                                    aria-controls="section-{{ $index }}">
                                    <h5 class="mb-0"><strong>{{ $section->name }}</strong></h5>
                                </button>
                            </div>
                        </h2>

                        <div id="section-{{ $index }}" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <div class="table-responsive">
                                    <table class="table table-hover table-striped table-condensed table-bordered table-sm">
                                        <thead>
                                            <tr>
                                                <th>Inspection Item</th>
                                                <th>Catatan</th>
                                                @foreach ($status as $item)
                                                    <th class="text-center">{{ $item->name }}</th>
                                                @endforeach
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($section->items as $key => $item)
                                                @php
                                                    $currentDailyItem = $daily->detail->firstWhere(
                                                        'forms_items_id',
                                                        $item->id,
                                                    );
                                                    $statusItem = $item->status->pluck('name')->toArray();
                                                @endphp
                                                <tr>
                                                    <input type="hidden" name="forms_items_id[{{ $index }}][{{ $key }}]"
                                                        value="{{ $item->id }}">

                                                    <td>{{ $item->name }}</td>

                                                    <td style="width: 30%">
                                                        <input type="text" name="catatan[{{ $index }}][{{ $key }}]"
                                                            class="form-control" value="{{ $currentDailyItem->catatan ?? '' }}">
                                                    </td>

                                                    @foreach ($status as $statusKey => $stTd)
                                                        @php
                                                            $isChecked =
                                                                optional($currentDailyItem)->status == $stTd->name;
                                                        @endphp
                                                        <td class="text-center">
                                                            <input required type="radio" class="btn-check"
                                                                name="status[{{ $index }}][{{ $key }}]"
                                                                id="status-{{ $index }}-{{ $key }}-{{ $statusKey }}"
                                                                value="{{ $stTd->id }}" {{ $isChecked ? 'checked' : '' }}>
                                                            @if ($stTd->name === 'Baik' && in_array('Baik', $statusItem))
                                                                <label class="btn btn-outline-success"
                                                                    for="status-{{ $index }}-{{ $key }}-{{ $statusKey }}">{{ $stTd->name }}</label>
                                                            @elseif($stTd->name === 'Rusak' && in_array('Rusak', $statusItem))
                                                                <label class="btn btn-outline-danger"
                                                                    for="status-{{ $index }}-{{ $key }}-{{ $statusKey }}">{{ $stTd->name }}</label>
                                                            @elseif($stTd->name === 'Cukup' && in_array('Cukup', $statusItem))
                                                                <label class="btn btn-outline-warning"
                                                                    for="status-{{ $index }}-{{ $key }}-{{ $statusKey }}">{{ $stTd->name }}</label>
                                                            @elseif($stTd->name === 'N/A' && in_array('N/A', $statusItem))
                                                                <label class="btn btn-outline-primary"
                                                                    for="status-{{ $index }}-{{ $key }}-{{ $statusKey }}">{{ $stTd->name }}</label>
                                                            @endif
                                                        </td>
                                                    @endforeach
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            {{-- Note Tambahan --}}
            <div class="col-lg-12 mt-4">
                <div class="form-group mb-3">
                    <textarea name="downtime_note" id="downtime_note" class="form-control" cols="30" rows="5"
                        placeholder="Note">{{ $daily->downtime_note ?? '' }}</textarea>
                </div>
            </div>
            <div class="d-flex justify-content-between">
                <div>
                    <button type="submit" id="submit" class="btn btn-primary">Lanjutkan</button>
                </div>
            </div>
        </div>
    </form>
@endsection
@push('extraJS')
    <script>
        @if (session('success'))
            Swal.fire({
                icon: 'success',
                title: 'Berhasil!',
                text: "{{ session('success') }}",
                timer: 2000,
                showConfirmButton: false
            });
        @endif

        @if (session('error'))
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: "{{ session('error') }}",
            });
        @endif
    </script>
    <script>
        let isSubmitted = false;
        const dailyId = "{{ $daily->id }}";

        $(document).ready(function () {
            // Jika user sudah pernah keluar dari halaman tanpa submit
            const isCanceled = localStorage.getItem(`daily_canceled_${dailyId}`);
            if (isCanceled) {
                const nextBtn = document.getElementById('nextBtn');
                if (nextBtn) {
                    nextBtn.disabled = true;
                    nextBtn.classList.add('btn-secondary');
                    nextBtn.classList.remove('btn-primary');
                    nextBtn.innerText = 'Data sudah dibatalkan';
                }
            }

            // Validasi dan submit form
            $('form').on('submit', function (e) {
                let valid = true;
                let firstInvalid = null;
                isSubmitted = true;

                // Hapus tanda * lama
                $('table tr td:first span.text-danger').remove();

                // Loop tiap input radio unik berdasarkan nama
                const radioNames = [];
                $('input[type="radio"]').each(function () {
                    const name = $(this).attr('name');
                    if (!radioNames.includes(name)) {
                        radioNames.push(name);
                    }
                });

                // Periksa setiap pertanyaan
                radioNames.forEach(function (name) {
                    const group = $(`input[name='${name}']`);
                    const hasChecked = group.is(':checked');

                    if (!hasChecked) {
                        valid = false;
                        const firstRow = group.first().closest('tr');
                        const tdLabel = firstRow.find('td:first');

                        // Tambahkan tanda * merah jika belum ada
                        if (tdLabel.find('span.text-danger').length === 0) {
                            tdLabel.append(
                                ' <span class="text-danger" style="font-size:20px;">*</span>');
                        }

                        if (!firstInvalid) firstInvalid = firstRow;

                        // Ambil nomor group utama dari name (contoh: status[4][9] → 4)
                        const mainGroup = name.match(/status\[(\d+)\]/);
                        if (mainGroup && mainGroup[1]) {
                            const groupId = mainGroup[1];
                            const collapse = $(`#collapse-${groupId}`);
                            if (collapse.length) {
                                const trigger = $(`button[data-bs-target="#collapse-${groupId}"]`);
                                trigger.removeClass('collapsed');
                                collapse.addClass('show');
                            }
                        }
                    }
                });

                if (!valid) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Validasi Gagal',
                        text: 'Masih ada pertanyaan yang belum dijawab!',
                        confirmButtonText: 'Periksa Kembali'
                    });

                    if (firstInvalid) {
                        $('html, body').animate({
                            scrollTop: firstInvalid.offset().top - 150
                        }, 600);
                    }

                    e.preventDefault();
                    return;
                }

                // Jika semua valid
                Swal.fire({
                    title: 'Sedang Proses',
                    text: 'Mohon tunggu sebentar...',
                    allowOutsideClick: false,
                    didOpen: () => Swal.showLoading()
                });

                // Hapus flag cancel jika berhasil submit
                localStorage.removeItem(`daily_canceled_${dailyId}`);

                this.submit();
            });

            // Hapus tanda * kalau user pilih salah satu radio
            $(document).on('change', 'input[type="radio"]', function () {
                const name = $(this).attr('name');
                const firstRow = $(`input[name='${name}']`).first().closest('tr');
                firstRow.find('td:first span.text-danger').remove();
            });
        });

        // Saat user keluar dari halaman (klik back / close tab / reload)
        window.addEventListener('beforeunload', function (e) {
            if (!isSubmitted) {
                const url = `{{ route('daily-report.update', ':id') }}`.replace(':id', dailyId);

                const csrfToken = '{{ csrf_token() }}';

                const formData = new FormData();
                formData.append('_method', 'DELETE');
                formData.append('_token', csrfToken);

                // Simpan info bahwa user membatalkan
                localStorage.setItem(`daily_canceled_${dailyId}`, 'true');

                navigator.sendBeacon(url, formData);
            }
        });
    </script>
@endpush
