<x-guest-layout>
    <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
        data-sidebar-position="fixed" data-header-position="fixed">

        <div
            class="overflow-hidden position-relative radial-gradient min-vh-100 
            d-flex align-items-center justify-content-center">

            <div class="d-flex align-items-center justify-content-center w-100">
                <div class="row justify-content-center w-100">
                    <div class="col-md-10 col-lg-8 col-xxl-4">

                        <div class="card shadow-lg border-0">
                            <div class="card-body p-4">
                                <div class="text-center mb-4">
                                    <h3 class="fw-bold">REGISTER</h3>
                                </div>

                                <form id="registerForm" action="{{ route('register') }}" method="POST">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-12">
                                            {{-- Nama --}}
                                            <div class="mb-3">
                                                <label for="name" class="form-label">Nama</label>
                                                <input type="text" id="name" name="name" class="form-control"
                                                    placeholder="Masukkan nama" value="{{ old('name') }}" required>
                                                <x-input-error :messages="$errors->get('name')" class="mt-2" />
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            {{-- Email --}}
                                            <div class="mb-3">
                                                <label for="email" class="form-label">Email</label>
                                                <input type="email" id="email" name="email" class="form-control"
                                                    placeholder="Masukkan Email" value="{{ old('email') }}" required>
                                                <x-input-error :messages="$errors->get('email')" class="mt-2" />
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            {{-- Username --}}
                                            <div class="mb-3">
                                                <label for="username" class="form-label">Username</label>
                                                <input type="text" id="username" name="username"
                                                    class="form-control" placeholder="Masukkan username"
                                                    value="{{ old('username') }}" required>
                                                <x-input-error :messages="$errors->get('username')" class="mt-2" />
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            {{-- Password --}}
                                            <div class="mb-3">
                                                <label for="password" class="form-label">Password</label>
                                                <input type="password" id="password" name="password"
                                                    class="form-control" placeholder="Masukkan Password" required>
                                                <x-input-error :messages="$errors->get('password')" class="mt-2" />
                                            </div>
                                        </div>
                                        <div class="col-lg-6">

                                            {{-- Confirm Password --}}
                                            <div class="mb-3">
                                                <label for="password_confirmation" class="form-label">Konfirmasi
                                                    Password</label>
                                                <input type="password" id="password_confirmation"
                                                    name="password_confirmation" class="form-control"
                                                    placeholder="Ulangi Password" required>
                                            </div>

                                        </div>
                                        <div class="col-lg-6">
                                            {{-- Lokasi --}}
                                            <div class="mb-3">
                                                <label for="location_id" class="form-label">Lokasi </label>
                                                <select id="location_id" name="location_id" class="form-select"
                                                    required>
                                                    <option value="">Pilih Lokasi</option>
                                                    @foreach ($location as $item)
                                                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                                                    @endforeach
                                                </select>
                                                <x-input-error :messages="$errors->get('lokasi')" class="mt-2" />
                                            </div>
                                        </div>
                                        <div class="col-lg-6">

                                            {{-- Roles --}}
                                            <div class="mb-4">
                                                <label for="role_id" class="form-label">Roles</label>
                                                <select id="role_id" name="role_id" class="form-select" required>
                                                    <option value="">Pilih Role</option>
                                                    @foreach ($role as $item)
                                                        @if (stripos($item->role, 'operator') !== false || stripos($item->role, 'driver') !== false)
                                                            <option value="{{ $item->id }}">{{ $item->role }}
                                                            </option>
                                                        @endif
                                                    @endforeach

                                                </select>
                                                <x-input-error :messages="$errors->get('role')" class="mt-2" />
                                            </div>
                                        </div>
                                    </div>
                                    <x-primary-submit class="w-100">
                                        {{ __('Masuk') }}
                                    </x-primary-submit>
                            </div>


                            </form>
                            <div class="mt-4 mb-4 d-flex align-items-center justify-content-center">
                                Sudah punya akun ? <a class="text-primary fw-bold" href="{{ route('login') }}">
                                    Login</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        < script >
            @if (session('success'))
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    text: "{{ session('success') }}",
                    timer: 2000,
                    showConfirmButton: false
                });
            @endif

        @if (session('error'))
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: "{{ session('error') }}",
            });
        @endif
    </script>
    $(document).ready(function() {
    $('#password_confirmation').on('blur', function() {
    const pass = $('#password').val();
    const confirm = $(this).val();

    if (confirm.length > 0 && pass !== confirm) {
    Swal.fire({
    icon: 'error',
    title: 'Password Tidak Sama!',
    text: 'Pastikan konfirmasi password sesuai dengan password.',
    confirmButtonText: 'OK',
    confirmButtonColor: '#3085d6'
    });
    $(this).val('');
    }
    });

    $('#registerForm').on('submit', function(e) {
    e.preventDefault();
    let form = $(this);
    let url = form.attr('action');

    let data = form.serializeArray().filter(item => item.name !== 'password_confirmation');

    $.ajax({
    url: url,
    type: 'POST',
    data: $.param(data),
    success: function(response) {
    Swal.fire({
    icon: 'success',
    title: 'Berhasil!',
    text: 'Registrasi berhasil, silakan login.',
    timer: 2000,
    showConfirmButton: false
    }).then(() => {
    window.location.href = "{{ route('login') }}";
    });
    },
    error: function(xhr) {
    let message = 'Terjadi kesalahan, silakan coba lagi.';
    if (xhr.responseJSON && xhr.responseJSON.message) {
    message = xhr.responseJSON.message;
    }

    Swal.fire({
    icon: 'error',
    title: 'Gagal!',
    text: message,
    confirmButtonText: 'OK',
    confirmButtonColor: '#d33'
    });
    }
    });
    });
    });
    </script>

</x-guest-layout>
