<x-guest-layout>
    <!-- Session Status -->
    <x-auth-session-status class="mb-4" :status="session('status')" />

    <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
        data-sidebar-position="fixed" data-header-position="fixed">
        <div
            class="overflow-hidden position-relative radial-gradient min-vh-100 d-flex align-items-center justify-content-center">
            <div class="d-flex align-items-center justify-content-center w-100">
                <div class="row justify-content-center w-100">
                    <div class="col-md-8 col-lg-6 col-xxl-3">
                        <div class="mb-0 card">
                            <div class="card-body">
                                <a href="" class="py-3 text-center text-nowrap logo-img d-block w-100">
                                    <h3>DOCU</h3>
                                </a>
                                <p class="text-center">Silakan login untuk mulai menggunakan
                                    aplikasi.
                                </p>
                                <form method="POST" action="{{ route('login') }}">
                                    @csrf
                                    <div>
                                        <x-input-label for="login" :value="__('Email atau Username')" />
                                        <x-text-input id="login" class="block w-full mt-1" type="text"
                                            name="login_identifier" :value="old('login_identifier')" required autofocus
                                            autocomplete="login_identifier" />
                                        <x-input-error :messages="$errors->get('login_identifier')" class="mt-2" />
                                    </div>
                                    <!-- Password -->
                                    <div class="mt-4">
                                        <x-input-label for="password" :value="__('Password')" />

                                        <x-text-input id="password" class="block w-full mt-1" type="password"
                                            name="password" required autocomplete="current-password" />

                                        <x-input-error :messages="$errors->get('password')" class="mt-2" />
                                    </div>

                                    <div class="mt-4 mb-4 d-flex align-items-center justify-content-between">
                                        <div class="form-check">
                                            <input class="form-check-input primary" type="checkbox" value="1"
                                                id="flexCheckChecked" name="remember" checked>
                                            <label class="form-check-label text-dark" for="flexCheckChecked">
                                                Remember this Device
                                            </label>
                                        </div>
                                        <a class="text-primary fw-bold" href="{{ route('password.request') }}">Lupa
                                            password ?</a>
                                    </div>
                                    <x-primary-submit class="w-100">
                                        {{ __('Masuk') }}
                                    </x-primary-submit>

                                </form>
                                <div class="mt-4 mb-4 d-flex align-items-center justify-content-center">
                                    username : demo@pmmsite.id <br>
                                    password : demo1234
                                </div>
                                <div class="card shadow-sm border-0 text-center p-4 mt-3 download-card"
                                    style="cursor: pointer; transition: all 0.3s ease;">
                                    <h5 class="fw-bold mb-2">Download APK DOCU</h5>
                                    <p class="text-muted mb-3">Klik di bawah untuk mengunduh aplikasi DOCU.</p>
                                    <a href="{{ asset("docu-apk.apk") }}" download class="btn btn-primary px-4">
                                        <i class="fas fa-download me-2"></i> Download Sekarang
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</x-guest-layout>

@push('extraJS')
    <script>
        document.querySelector('.download-card').addEventListener('click', function () {
            window.location.href =
                "https://drive.google.com/file/d/1joWBHundQo4ICknKJXLPxDxK0Bvlckl6/view?usp=sharing";
        });
        @if (session('success'))
            Swal.fire({
                icon: 'success',
                title: 'Berhasil!',
                text: "{{ session('success') }}",
                timer: 2000,
                showConfirmButton: false
            });
        @endif

        @if (session('error'))
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: "{{ session('error') }}",
            });
        @endif
    </script>
@endpush
