$(document).ready(function () {
    $('.select2').select2({ theme: "bootstrap" });
});

$(document).on('input', '.only-number', function () {
    this.value = this.value.replace(/\D/g, '');
});

$(document).on('input', ".phone-number", function () {
    this.value = this.value.replace(/\D/g, '').substring(0, 15);
});
$(document).on("click", "[type='date']", function () {
    // langsung buka datepicker bawaan browser
    this.showPicker && this.showPicker();
});
$(document).on('input', '.rupiah', function () {
    let angka = this.value.replace(/\D/g, '');
    this.value = angka.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
});
$(document).on('input', '.rupiah', function () {
    let angka = this.value.replace(/\D/g, '');
    this.value = angka.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
});

$(document).on('input', '.only-number', function () {
    let angka = this.value.replace(/\D/g, '');
    this.value = angka;
});
$.extend(true, $.fn.dataTable.defaults, {
    scrollX: true,
    searching: true,
    paging: true,
    ordering: true,
    language: {
        search: "",
        searchPlaceholder: "",
        lengthMenu: "Tampilkan _MENU_ entri per halaman",
        zeroRecords: "Tidak ditemukan data yang sesuai",
        info: "Menampilkan _START_ sampai _END_ dari _TOTAL_ entri",
        infoEmpty: "Menampilkan 0 sampai 0 dari 0 entri",
        infoFiltered: "(disaring dari _MAX_ total entri)",
        paginate: {
            first: "Pertama",
            last: "Terakhir",
            next: "Berikutnya",
            previous: "Sebelumnya"
        },
        emptyTable: "Tidak ada data tersedia di tabel",
        loadingRecords: "Memuat...",
        processing: "Memproses...",
    }
});

$('.data-table').on('draw.dt', function () {
    // Hanya tambahkan tombol jika belum ada
    $('.dt-input[type="search"]').off("keyup.DT")
    if (!$('.dt-custom-search-btn').length) {
        $('.dt-input[type="search"]').after(`
            <button type="button" class="dt-custom-search-btn btn btn-primary ms-2">Cari</button>
        `);
    }
});

$('.data-table').on('init.dt', function () {
    const $searchInput = $('.dt-input[type="search"]');
    $searchInput.off(); // Hapus semua event bawaan
    if (!$('.dt-custom-search-btn').length) {
        $searchInput.after(`
            <button type="button" class="dt-custom-search-btn btn btn-primary ms-2">Cari</button>
        `);
    }
});


$(document).on('click', '.dt-custom-search-btn', function () {
    const $table = $('.data-table').DataTable();
    const keyword = $('.dt-input[type="search"]').val();
    $table.search(keyword).draw();
});

$(document).on('keydown', '.dt-input[type="search"]', function (e) {
    if (e.key === 'Enter') {
        e.preventDefault(); // Mencegah form submit jika ada
        const $table = $('.data-table').DataTable();
        const keyword = $(this).val();
        $table.search(keyword).draw();
    }
});


$(".sidebartoggler-xl").on("click", function () {
    if ($("#main-wrapper").hasClass("active-xl")) {
        $("#main-wrapper").removeClass("active-xl")
    } else {
        $("#main-wrapper").addClass("active-xl")
    }
    if ($(".left-sidebar").hasClass("active-xl")) {
        $(".left-sidebar").removeClass("active-xl")
    } else {
        $(".left-sidebar").addClass("active-xl")
    }
})

// format npwp on input
$('.npwp').on('input', function () {
    let val = $(this).val().replace(/\D/g, "");
    val = val.replace(/^(\d{2})(\d)/, "$1.$2")
        .replace(/^(\d{2})\.(\d{3})(\d)/, "$1.$2.$3")
        .replace(/^(\d{2})\.(\d{3})\.(\d{3})(\d)/, "$1.$2.$3.$4")
        .replace(/^(\d{2})\.(\d{3})\.(\d{3})\.(\d{1})(\d)/, "$1.$2.$3.$4-$5")
        .replace(/^(\d{2})\.(\d{3})\.(\d{3})\.(\d{1})-(\d{3})(\d)/, "$1.$2.$3.$4-$5.$6");

    val = val.substr(0, 20);
    $(this).val(val);
});
$('.nik').on('input', function () {
    let val = $(this).val().replace(/\D/g, "");
    val = val.substr(0, 16);
    $(this).val(val);
});




// FUNCTION HELPERS

if (typeof handleValidationErrors !== 'function') {
    function handleValidationErrors(xhr, form) {
        function dotToBracketNotation(field) {
            let parts = field.split('.');
            let first = parts.shift();
            let rest = parts.map(part => `[${part}]`).join('');
            return first + rest;
        }

        if (xhr.status === 422) {
            let errors = xhr.responseJSON.errors;
            for (let field in errors) {
                let input = form.find(`[name="${field}"]`);

                if (input.length === 0 && field.includes('.')) {
                    let nameAttr = dotToBracketNotation(field);
                    input = form.find(`[name="${nameAttr}"]`);
                }

                input.addClass('is-invalid');

                if (input.hasClass('select2-hidden-accessible')) {
                    // Untuk Select2
                    let select2Container = input.next('.select2-container');
                    select2Container.addClass('is-invalid');

                    if (select2Container.next('.invalid-feedback').length === 0) {
                        select2Container.after(`<div class="invalid-feedback d-block">${errors[field][0]}</div>`);
                    } else {
                        select2Container.next('.invalid-feedback').text(errors[field][0]);
                    }
                } else {
                    // Untuk input biasa atau input dalam input-group
                    input.addClass('is-invalid');

                    if (input.next('.invalid-feedback').length === 0) {
                        if (input.parent().hasClass('input-group') || input.parent().hasClass('btn-group')) {
                            // Jika input di dalam input-group, pasang error setelah input-group
                            input.parent().after(`<div class="invalid-feedback d-block">${errors[field][0]}</div>`);
                        } else {
                            // Pasang error langsung setelah input
                            input.after(`<div class="invalid-feedback d-block">${errors[field][0]}</div>`);
                        }
                    } else {
                        if (input.parent().hasClass('input-group') || input.parent().hasClass('btn-group')) {
                            input.parent().next('.invalid-feedback').text(errors[field][0]);
                        } else {
                            input.next('.invalid-feedback').text(errors[field][0]);
                        }
                    }
                }


            }
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Gagal!',
                text: 'Terjadi kesalahan pada server.'
            });
        }
    }

}



if (typeof clearFormErrors !== 'function') {
    function clearFormErrors(formSelector) {
        $(formSelector).find('.is-invalid').removeClass('is-invalid');
        $(formSelector).find('.invalid-feedback').remove();
        $(formSelector)[0].reset();
    }
}


if (typeof confirmDelete !== 'function') {
    /**
     * General delete confirmation function
     * @param {string} id - ID data yang akan dihapus
     * @param {string} deleteUrlTemplate - URL template, gunakan :id untuk posisi ID
     * @param {string} itemName - Nama item yang akan tampil di pesan konfirmasi
     */
    function confirmDelete(id, deleteUrlTemplate, itemName) {
        return new Promise((resolve, reject) => {
            Swal.fire({
                title: `Yakin ingin menghapus ${itemName} ini?`,
                text: "Data tidak dapat dikembalikan setelah dihapus.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#e3342f',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    const deleteUrl = deleteUrlTemplate.replace(':id', id);

                    $.ajax({
                        url: deleteUrl,
                        type: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function () {
                            $('.data-table').DataTable().ajax.reload();
                            Swal.fire({
                                icon: 'success',
                                title: 'Berhasil!',
                                text: `${itemName} berhasil dihapus`,
                                timer: 2000,
                                showConfirmButton: false
                            });
                            resolve("success"); // ✅ return status
                        },
                        error: function (xhr) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Gagal!',
                                text: xhr.responseJSON?.message ?? `${itemName} tidak bisa dihapus karena sedang digunakan.`
                            });
                            resolve("error"); // ✅ return status
                        }
                    });
                } else {
                    resolve("cancel"); // ✅ kalau user batal
                }
            });
        });
    }

}

if (typeof initSelect2 !== 'function') {
    /**
 * Inisialisasi Select2 di dalam modal.
 * @param {string|HTMLElement|jQuery} selector - Selector atau elemen untuk Select2.
 * @param {string|HTMLElement|jQuery} parentModal - Selector atau elemen modal sebagai parent dropdown.
 * @param {string} [placeholder] - Placeholder opsional (default: "Pilih opsi").
 */
    function initSelect2(selector, parentModal, placeholder) {

        $(selector).select2({
            dropdownParent: $(parentModal),
            width: '100%',
            allowClear: true,
            theme: 'bootstrap',
            placeholder: placeholder || 'Pilih opsi'
        });
    }
}


// Pastikan jQuery sudah dimuat sebelum kode ini
$(function () {
    $('table').each(function () {
        var $table = $(this);
        // jika table belum berada di dalam .table-responsive (cek ancestor terdekat)
        if ($table.closest('.table-responsive').length === 0) {
            $table.wrap('<div class="table-responsive"></div>');
        }
    });
});
