<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class action extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $resources = [
            "Master Data" => [
                'locations' => 'Locations',
                'users' => 'Users',
                'roles' => 'Roles',
                'actions' => 'Actions',
                'status-checklist' => 'Status Checklist',
                'shift' => 'Shift',
            ],
            "Report" => [
                'inspection' => 'Supervisi Report',
                'daily-report' => 'Laporan Checklist Harian',
                'monthly-report' => 'Laporan Checklist Bulanan',
            ],
            "Lainnya" => [
                "swp" => "SWP",
                "stbm" => "STBM",
                'manufactures' => 'Pabrikan',
                'units' => 'Data Unit',
                'unit-type' => 'Jenis Unit',
                "checklist" => "Checklist",
                "checklist-sections" => "Checklist Section",
                "checklist-items" => "Checklist Item",
            ],
        ];

        foreach ($resources as $parentMenu => $resource) {
            foreach ($resource as $url => $r) {
                $data = [
                    'name' => $r,
                    'parent_menu' => $parentMenu,
                    'base_url' => $url,
                    'created_at' => now(),
                    'updated_at' => now(),
                ];
                DB::table('actions')->insert($data);
            }
        }


        DB::table("actions")->get()->map(function ($action) {
            DB::table("action_roles")->insert([
                "role_id" => 1,
                "action_id" => $action->id,
                "read" => 1,
                "create" => 1,
                "update" => 1,
                "delete" => 1,
                "created_at" => now(),
                "updated_at" => now(),
            ]);
        });
    }
}
