<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('nik', 20)->nullable()->after('id')->nullable()->default(null);
            $table->date('tgl_lahir')->nullable()->after('nik')->nullable()->default(null);
            $table->string('no_hp', 20)->nullable()->after('tgl_lahir')->nullable()->default(null);
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['nik', 'tgl_lahir', 'no_hp']);
        });
    }
};