<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stbm', function (Blueprint $table) {
            $table->id();
            $table->foreignId("location_id")->constrained("locations")->restrictOnUpdate()->restrictOnDelete();
            $table->string("name", 70);
            $table->text("topic");
            $table->text("description");
            $table->dateTime("date");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('s_t_b_m_s');
    }
};
