<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('dailies', function (Blueprint $table) {
            $table->foreignId('unit_id')
                  ->after('location_id') // letakkan setelah location_id
                  ->constrained('units')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('dailies', function (Blueprint $table) {
            $table->dropForeign(['unit_id']);
            $table->dropColumn('unit_id');
        });
    }
};