<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('dailies', function (Blueprint $table) {
            $table->foreignId('location_id')
                  ->after('shift_id')
                  ->constrained('locations')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('dailies', function (Blueprint $table) {
            $table->dropForeign(['location_id']);
            $table->dropColumn('location_id');
        });
    }
};