<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('form_item_statuses', function (Blueprint $table) {
            $table->id();

            // Relasi ke form_items
            $table->foreignId('form_item_id')
                ->constrained('form_items')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            // Relasi ke statuses
            $table->foreignId('status_id')
                ->constrained('status')
                ->onUpdate('restrict')
                ->onDelete('restrict');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('form_item_statuses');
    }
};
