<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('forms', function (Blueprint $table) {
            $table->renameColumn("catatan", "note");
            $table->dropColumn("jenis");
            $table->foreignId('type_unit_id')->constrained("type_units")
                ->onUpdate("restrict")
                ->onDelete("restrict");
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('forms', function (Blueprint $table) {
            $table->renameColumn("note", "catatan");
            $table->string('jenis');
            $table->dropColumn("type_unit_id");
        });
    }
};
