<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::create('detail_dailies', function (Blueprint $table) {
            $table->id();
            $table->foreignId('dailies_id')->constrained('dailies')->onUpdate('restrict')->onDelete('restrict');
            $table->foreignId('unit_id')->constrained('units')->onUpdate('restrict')->onDelete('restrict');
            $table->foreignId('form_item_id')->constrained('form_items')->onUpdate('restrict')->onDelete('restrict');
            $table->enum('status', ['Baik','Rusak', 'Layak Pakai', 'Tidak Tersedia']); 
            $table->text('note')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('detail_dailies');
    }
};
