<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('units', function (Blueprint $table) {
            $table->id();
            $table->foreignId('location_id')->constrained('sites')->onUpdate('restrict')->onDelete('restrict');
            $table->foreignId('type_id')->constrained('type_units')->onUpdate('restrict')->onDelete('restrict');
            $table->foreignId('manufacture_id')->nullable()->constrained('manufactures')->onUpdate('restrict')->onDelete('restrict');
            $table->string('unit_code', 50);
            $table->string('unit_type', 50);
            $table->integer('production_year');
            $table->string('serial_number_unit', 100)->nullable();
            $table->string('serial_number_chassis', 100)->nullable();
            $table->integer('hours_meter')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('units');
    }
};
