<?php

use Illuminate\Support\Str;

class PermissionHelper
{
    public static function getPermissions()
    {
        $user = auth()->user();
        $role = $user->role;
        $actions = $role->access;
        $allowedUrl = [];

        foreach ($actions as $action) {
            $value = $action->action;
            $routeName = rtrim(str_replace(['/', '-'], ['', '_'], $value->base_url), 's');

            if ($action->read) {
                $allowedUrl['GET'][] = ["action" => "read", "base_url" => $value->base_url, "url" => $value->base_url];
                $allowedUrl['HEAD'][] = ["action" => "read", "base_url" => $value->base_url, "url" => $value->base_url];
                $allowedUrl['GET'][] = ["action" => "read", "base_url" => $value->base_url, "url" => $value->base_url . '/{' . $routeName . '}'];
                $allowedUrl['HEAD'][] = ["action" => "read", "base_url" => $value->base_url, "url" => $value->base_url . '/{' . $routeName . '}'];
                $allowedUrl['GET'][] = ["action" => "read", "base_url" => $value->base_url, "url" => $value->base_url . '/{' . $routeName . '}/show'];
                $allowedUrl['HEAD'][] = ["action" => "read", "base_url" => $value->base_url, "url" => $value->base_url . '/{' . $routeName . '}/show'];
            }

            if ($action->create) {
                $allowedUrl['POST'][] = ["action" => "create", "base_url" => $value->base_url, "url" => $value->base_url];
                $allowedUrl['GET'][] = ["action" => "create", "base_url" => $value->base_url, "url" => $value->base_url . '/create'];
                $allowedUrl['HEAD'][] = ["action" => "create", "base_url" => $value->base_url, "url" => $value->base_url . '/create'];
            }

            if ($action->update) {
                $allowedUrl['PUT'][] = ["action" => "update", "base_url" => $value->base_url, "url" => $value->base_url . '/{' . $routeName . '}'];
                $allowedUrl['PATCH'][] = ["action" => "update", "base_url" => $value->base_url, "url" => $value->base_url . '/{' . $routeName . '}'];
                $allowedUrl['GET'][] = ["action" => "update", "base_url" => $value->base_url, "url" => $value->base_url . '/{' . $routeName . '}/edit'];
                $allowedUrl['HEAD'][] = ["action" => "update", "base_url" => $value->base_url, "url" => $value->base_url . '/{' . $routeName . '}/edit'];
            }

            if ($action->delete) {
                $allowedUrl['DELETE'][] = ["action" => "delete", "base_url" => $value->base_url, "url" => $value->base_url . '/{' . $routeName . '}'];
            }
        }

        return $allowedUrl;
    }

    /**
     * @return object{read: bool, update: bool, delete: bool, create: bool}
     */
    public static function hasPermission(string $routePath): object
    {
        $routePath = str_replace("/", "", $routePath);
        $permissions = self::getPermissions();
        $access = (object) [
            "read" => false,
            "update" => false,
            "delete" => false,
            "create" => false,
        ];
        // gabungkan semua method
        $methods = ["GET", "HEAD", "POST", "PUT", "PATCH", "DELETE"];
        foreach ($methods as $method) {
            if (!isset($permissions[$method])) {
                continue;
            }

            foreach ($permissions[$method] as $value) {
                if ($value["base_url"] === $routePath) {
                    $access->{$value["action"]} = true;
                }
            }
        }

        return $access;
    }


    private static function mapActionToMethod($action)
    {
        if (Str::contains($action, 'READ'))
            return 'GET';
        if (Str::contains($action, 'SHOW'))
            return 'SHOW';
        if (Str::contains($action, 'CREATE'))
            return 'POST';
        if (Str::contains($action, 'UPDATE'))
            return 'PUT';
        if (Str::contains($action, 'DELETE'))
            return 'DELETE';

        return 'GET';
    }


    public static function hasAllAccess()
    {
        if (!auth()->check()) {
            return true;
        }

        $text = strtolower(auth()->user()->role->role);
        $role = auth()->user()->role;
        // $allAccess = false;
        // if (stripos($text, 'All site') !== false) {
        //     $allAccess = true;
        // }

        // return in_array(strtolower(auth()->user()->role->role), ["admin", "so"]) && $allAccess;
        // dd($role);
        return $role->isAllLocation == "1" || $role->isAllLocation == 1 || $role->isAllLocation == true;
    }
    public static function IsOperator()
    {
        if (!auth()->check()) {
            return true;
        }
        $role = auth()->user()->role;

        return $role->isOperator == "1" || $role->isOperator == 1 || $role->isOperator == true;
    }
}
