<?php

use Illuminate\Support\Facades\DB;

class Helpers
{
    public static function formatDate($date)
    {
        return \Carbon\Carbon::parse($date)->format('d-m-Y');
    }
    public static function currency($number, $prefix = 'Rp ')
    {
        if ($number === null || $number === '') {
            return $prefix . '0';
        }
        return $prefix . number_format($number, 0, ',', '.');
    }

    public static function unCurrency($formatted)
    {
        // Hilangkan semua karakter non-angka
        return (int) preg_replace('/[^\d]/', '', $formatted);
    }
}