<?php
namespace App\Repositories;

use App\Interfaces\TypeunitRepositoryInterface;
use App\Models\TypeUnit;
use PermissionHelper;

class TypeunitRepository implements TypeunitRepositoryInterface
{
    protected $model;

    public function __construct(TypeUnit $unit_type)
    {
        $this->model = $unit_type;
    }

    public function all()
    {
        $role = strtolower(auth()->user()->role->role);

        if ($role == 'operator' || $role == 'driver' ) {
            // operator
            if (PermissionHelper::IsOperator()) {
                return $this->model
                    ->whereIn('name', ['Excavator', 'WHEEL LOADER'])
                    ->orderBy('id', 'desc')
                    ->get();
            } else {
                //  bukan operator
                return $this->model
                    ->whereNotIn('name', ['Excavator', 'WHEEL LOADER'])
                    ->orderBy('id', 'desc')
                    ->get();
            }
        }

        return $this->model->orderBy('id', 'desc')->get();
    }


    public function find($id)
    {
        return $this->model->findOrFail($id);
    }

    public function create(array $data)
    {
        return $this->model->create($data);
    }

    public function update($id, array $data)
    {
        $location = $this->find($id);
        $location->update($data);
        return $location;
    }

    public function delete($id)
    {
        $location = $this->find($id);
        return $location->delete();
    }
}