<?php
namespace App\Repositories;

use App\Interfaces\SwpRepositoryInterface;
use App\Models\Swp;

class SwpRepository implements SwpRepositoryInterface
{
    private $swp;

    public function __construct(Swp $swp)
    {
        $this->swp = $swp;
    }

    public function all()
    {
        return $this->swp->orderBy("id", "asc")->get();
    }
    public function datatable()
    {
        return $this->swp
            ->when(empty(request('order')) || (request('order')[0]['name'] ?? 'DT_RowIndex') === 'DT_RowIndex', fn($q) => $q->orderBy('swp.id', 'desc'))
            // ->orderBy("id", "desc")
        ;
    }


    public function find($id)
    {
        return $this->swp->findOrFail($id);
    }

    public function create(array $data)
    {
        return $this->swp->create($data);
    }

    public function update($id, array $data)
    {
        $swp = $this->swp->find($id);
        $swp->update($data);
        return $swp;
    }

    public function delete($id)
    {
        $swp = $this->swp->find($id);
        return $swp->delete();

    }
}
