<?php
namespace App\Repositories;

use App\Interfaces\StatusRepositoryInterface;
use App\Models\Role;
use App\Models\Status;

class StatusRepository implements StatusRepositoryInterface
{
    private $status;

    public function __construct(Status $status)
    {
        $this->status = $status;
    }

    public function all()
    {
        return $this->status->orderBy("id", "asc")->get();
    }
    public function datatable()
    {
        return $this->status->orderBy("id", "desc");
    }


    public function find($id)
    {
        return $this->status->findOrFail($id);
    }

    public function create(array $data)
    {
        return $this->status->create($data);
    }

    public function update($id, array $data)
    {
        $location = $this->find($id);
        $location->update($data);
        return $location;
    }

    public function delete($id)
    {
        $status = $this->status->find($id);
        return $status->delete();

    }
}