<?php
namespace App\Repositories;

use App\Interfaces\ShiftRepositoryInterface;
use App\Models\Shift;

class ShiftRepository implements ShiftRepositoryInterface
{
    private $shift;

    public function __construct(Shift $shift)
    {
        $this->shift = $shift;
    }

    public function all()
    {
        return $this->shift->orderBy("id", "asc")->get();
    }
    public function datatable()
    {
        return $this->shift->orderBy("id", "desc");
    }


    public function find($id)
    {
        return $this->shift->findOrFail($id);
    }

    public function create(array $data)
    {
        return $this->shift->create($data);
    }

    public function update($id, array $data)
    {
        $location = $this->find($id);
        $location->update($data);
        return $location;
    }

    public function delete($id)
    {
        $shift = $this->shift->find($id);
        return $shift->delete();

    }
}