<?php
namespace App\Repositories;

use App\Interfaces\LocationRepositoryInterface;
use App\Interfaces\RoleRepositoryInterface;
use App\Models\Role;

class RoleRepository implements RoleRepositoryInterface
{
    private $role;

    public function __construct(Role $role)
    {
        $this->role = $role;
    }

    public function all()
    {
        return $this->role->all();
    }
    public function trashed()
    {
        return $this->role->onlyTrashed();
    }

    public function find($id)
    {
        return $this->role->with("access")->findOrFail($id);
    }

    public function create(array $data)
    {
        return $this->role->create($data);
    }

    public function update($id, array $data)
    {
        $location = $this->find($id);
        $location->update($data);
        return $location;
    }

    public function delete($id)
    {
        $role = $this->role->withTrashed()->find($id);
        $option = request()->option;
        if ($option == "delete") {
            return $role->delete();
        } else if ($option == "force-delete") {
            return $role->forceDelete();
        } else if ($option == "restore") {
            return $role->restore();
        }
    }
}