<?php
namespace App\Repositories;

use App\Interfaces\ManufactureRepositoryInterface;
use App\Models\Manufacture;

class ManufactureRepository implements ManufactureRepositoryInterface
{
    protected $model;

    public function __construct(Manufacture $manufacture)
    {
        $this->model = $manufacture;
    }

    public function all()
    {
        return $this->model->orderBy('id', 'desc')->get();
    }

    public function find($id)
    {
        return $this->model->findOrFail($id);
    }

    public function create(array $data)
    {
        return $this->model->create($data);
    }

    public function update($id, array $data)
    {
        $manufacture = $this->find($id);
        $manufacture->update($data);
        return $manufacture;
    }

    public function delete($id)
    {
        $manufacture = $this->find($id);
        return $manufacture->delete();
    }

    public function datatable()
    {
        return $this->model
            ->when(empty(request('order')) || (request('order')[0]['name'] ?? 'DT_RowIndex') === 'DT_RowIndex', fn($q) => $q->orderBy('manufactures.id', 'desc'))
            // ->orderBy('id', 'desc')
        ;
    }
}
