<?php
namespace App\Repositories;

use App\Models\Location;
use App\Interfaces\LocationRepositoryInterface;
use Illuminate\Support\Facades\DB;
use PermissionHelper;

class LocationRepository implements LocationRepositoryInterface
{
    protected $model;

    public function __construct(Location $location)
    {
        $this->model = $location;
    }

    public function forAll()
    {
        $user = auth()->user();

        if (!PermissionHelper::hasAllAccess()) {
            return $this->model->where('id', $user->location_id)->get();
        }

        return $this->model->orderBy('id')->get();
    }

    public function all()
    {
        $user = auth()->user();

        if (!PermissionHelper::hasAllAccess()) {
            return $this->model->where('id', $user->location_id)->get();
        }

        return $this->model->orderBy('id')->get();
    }

    public function locationForTranferPart()
    {
        return $this->model->orderBy('id', 'desc')->get();
    }

    public function find($id)
    {
        return $this->model->findOrFail($id);
    }

    public function create(array $data)
    {
        return $this->model->create($data);
    }

    public function update($id, array $data)
    {
        $location = $this->model->find($id);
        $location->update($data);
        return $location;
    }

    public function delete($id)
    {
        $option = request()->option;
        $location = $this->model->withTrashed()->findOrFail($id);

        if ($option === "delete") {
            return $location->delete();
        }

        if ($option === "restore") {
            return $location->restore();
        }

        if ($option === "force-delete") {
            DB::beginTransaction();

            try {
                if (DB::table('units')->where('location_id', $location->id)->exists()) {
                    DB::table('units')->where('location_id', $location->id)->delete();
                }

                $dailies = DB::table('dailies')->where('location_id', $location->id)->get();
                $stbm = DB::table('stbm')->where('location_id', $location->id)->get();

                if ($dailies->count() > 0) {

                    foreach ($dailies as $daily) {
                        DB::table('detail_dailies')->where('dailies_id', $daily->id)->delete();
                    }

                    DB::table('dailies')->where('location_id', $location->id)->delete();
                }
                
                if ($stbm->count() > 0) {

                    foreach ($stbm as $s) {
                        DB::table('stbm_image')->where('stbm_id', $s->id)->delete();
                        DB::table('stbm_participant')->where('stbm_id', $s->id)->delete();
                    }

                    DB::table('stbm')->where('location_id', $location->id)->delete();
                }

                DB::table('locations')->where('id', $location->id)->delete();

                DB::commit();
                return true;
            } catch (\Exception $e) {
                DB::rollBack();
                throw $e;
            }
        }

        return false;
    }

    public function datatable()
    {
        $user = auth()->user();

        if (!PermissionHelper::hasAllAccess()) {
            return $this->model->where('id', $user->location_id)->orderBy('id', 'desc');
        }

        return $this->model->query()
            // ->orderBy('id', 'asc')
        ;
    }
    public function datatableTrash()
    {
        $user = auth()->user();

        if (!PermissionHelper::hasAllAccess()) {
            return $this->model->where('id', $user->location_id)->orderBy('id', 'desc');
        }

        return $this->model->onlyTrashed()
            // ->orderBy('id', 'asc')
        ;
    }
}