<?php
namespace App\Repositories\ApiRpositories;

use App\Interfaces\ApiInterface\AuthRepositoryInterface;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AuthRepository implements AuthRepositoryInterface
{
    private $model;

    public function __construct(User $user)
    {
        $this->model = $user;
    }

    public function login($email)
    {
        return $this->model->where('email', $email)->orWhere('username', $email)->first();
    }

    public function updatePassword($userId, $oldPassword, $newPassword)
    {
        $user = $this->model->where('id', $userId)->first();

        if (!$user) {
            return [
                'success' => false,
                'message' => 'User tidak ditemukan.'
            ];
        }

        if (!Hash::check($oldPassword, $user->password)) {
            return [
                'success' => false,
                'message' => 'Password lama tidak sesuai.'
            ];
        }

        $user->password = Hash::make($newPassword);
        $user->save();

        return [
            'success' => true,
            'message' => 'Password berhasil diperbarui.'
        ];
    }
}
