<?php
namespace App\Repositories;

use App\Interfaces\ActionRoleRepositoryInterface;
use App\Models\ActionRole;

class ActionRoleRepository implements ActionRoleRepositoryInterface
{
    private $role;

    public function __construct(ActionRole $role)
    {
        $this->role = $role;
    }

    public function all()
    {
        return $this->role->all();
    }

    public function find($id)
    {
        return $this->role->findOrFail($id);
    }

    public function create(array $data)
    {
        return $this->role->create($data);
    }

    public function update($id, array $data)
    {
        $location = $this->find($id);
        $location->update($data);
        return $location;
    }

    public function delete($id)
    {
        $location = $this->find($id);
        return $location->delete();
    }

    public function where(string $column, mixed $value)
    {
        return $this->role->where($column, $value);
    }

    public function deleteByRoleId(string $roleId)
    {
        return $this->role->where('role_id', $roleId)->delete();
    }

}
