<?php
namespace App\Repositories;

use App\Interfaces\ActionRepositoryInterface;
use App\Models\Action;

class ActionRepository implements ActionRepositoryInterface
{
    private $action;

    public function __construct(Action $action)
    {
        $this->action = $action;
    }

    public function all()
    {
        return $this->action->orderBy("actions.id", "desc")->get();
    }

    public function find($id)
    {
        return $this->action->findOrFail($id);
    }

    public function create(array $data)
    {
        return $this->action->create($data);
    }

    public function update($id, array $data)
    {
        $location = $this->find($id);
        $location->update($data);
        return $location;
    }

    public function delete($id)
    {
        $location = $this->find($id);
        return $location->delete();
    }
}
