<?php

namespace App\Providers;

use App\Interfaces\ActionRepositoryInterface;
use App\Interfaces\ActionRoleRepositoryInterface;
use App\Interfaces\DailyRepositoryInterface;
use App\Interfaces\ApiInterface\AuthRepositoryInterface;
use App\Interfaces\ApiInterface\ChecklistRepositoryInterface;
use App\Interfaces\ApiInterface\MasterRepositoryInterface;
use App\Interfaces\FormRepositoryInterface;
use App\Interfaces\StatusRepositoryInterface;
use App\Interfaces\StbmRepositoryInterface;
use App\Interfaces\UserRepositoryInterface;
use App\Repositories\ActionRoleRepository;
use App\Repositories\FormRepository;
use App\Repositories\StatusRepository;
use App\Repositories\StbmRepository;
use App\Repositories\UserRepository;
use Illuminate\Support\ServiceProvider;
use App\Interfaces\LocationRepositoryInterface;
use App\Interfaces\ManufactureRepositoryInterface;
use App\Interfaces\RoleRepositoryInterface;
use App\Interfaces\ShiftRepositoryInterface;
use App\Interfaces\SwpRepositoryInterface;
use App\Interfaces\TypeunitRepositoryInterface;
use App\Interfaces\UnitRepositoryInterface;
use App\Repositories\ActionRepository;
use App\Repositories\DailyRepository;
use App\Repositories\ApiRpositories\AuthRepository;
use App\Repositories\ApiRpositories\ChecklistRepository;
use App\Repositories\ApiRpositories\MasterRepository;
use App\Repositories\LocationRepository;
use App\Repositories\ManufactureRepository;
use App\Repositories\RoleRepository;
use App\Repositories\ShiftRepository;
use App\Repositories\SwpRepository;
use App\Repositories\TypeunitRepository;
use App\Repositories\UnitRepository;
use Monolog\Formatter\FormatterInterface;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->bind(LocationRepositoryInterface::class, LocationRepository::class);
        $this->app->bind(RoleRepositoryInterface::class, RoleRepository::class);
        $this->app->bind(ActionRepositoryInterface::class, ActionRepository::class);
        $this->app->bind(UserRepositoryInterface::class, UserRepository::class);
        $this->app->bind(TypeunitRepositoryInterface::class, TypeunitRepository::class);
        $this->app->bind(ManufactureRepositoryInterface::class, ManufactureRepository::class);
        $this->app->bind(UnitRepositoryInterface::class, UnitRepository::class);
        $this->app->bind(ActionRoleRepositoryInterface::class, ActionRoleRepository::class);
        $this->app->bind(StatusRepositoryInterface::class, StatusRepository::class);
        $this->app->bind(ShiftRepositoryInterface::class, ShiftRepository::class);
        $this->app->bind(FormRepositoryInterface::class, FormRepository::class);
        $this->app->bind(DailyRepositoryInterface::class, DailyRepository::class);
        $this->app->bind(AuthRepositoryInterface::class, AuthRepository::class);
        $this->app->bind(MasterRepositoryInterface::class, MasterRepository::class);
        $this->app->bind(ChecklistRepositoryInterface::class, ChecklistRepository::class);
        $this->app->bind(SwpRepositoryInterface::class, SwpRepository::class);
        $this->app->bind(StbmRepositoryInterface::class, StbmRepository::class);

        $this->loadHelpers();
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }

    protected function loadHelpers(): void
    {
        foreach (glob(__DIR__ . '/../Helpers/*.php') as $filename) {
            require_once $filename;
        }
    }
}
