<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use PermissionHelper;

class Unit extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    public function unittype()
    {
        return $this->belongsTo(TypeUnit::class, 'type_id');
    }

    public function manufacture()
    {
        return $this->belongsTo(Manufacture::class);
    }

    public function location()
    {
        return $this->belongsTo(Location::class)->withTrashed();
    }

    public function daily()
    {
        return $this->hasMany(Daily::class, "unit_id");
    }

    /**
     * Filter Unit berdasarkan role dan status operator.
     */
    public function scopeFilterByRole($query)
    {
        $user = auth()->user();

        if (!$user) {
            return $query;
        }

        $roleName = strtolower($user->role->role ?? '');

        if (str_contains($roleName, 'operator') || str_contains($roleName, 'driver')) {

            if (PermissionHelper::IsOperator()) {
                return $query->whereHas('unittype', function ($q) {
                    $q->where('name', 'like', '%excavator%')
                        ->orWhere('name', 'like', '%loader%');
                });
            } else {
                return $query->whereHas('unittype', function ($q) {
                    $q->where(function ($sub) {
                        $sub->where('name', 'not like', '%excavator%')
                            ->where('name', 'not like', '%loader%');
                    });
                });
            }
        }

        return $query;
    }
}
