<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Stbm extends Model
{
    use HasFactory;
    protected $table = "stbm";
    protected $fillable = ["location_id", "user_id", "topic", "description", "date"];

    public function location()
    {
        return $this->belongsTo(Location::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function images()
    {
        return $this->hasMany(Stbm_Image::class, "stbm_id");
    }
    public function participant()
    {
        return $this->hasMany(Stbm_Participant::class, "stbm_id");
    }
}
