<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Role extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = "roles";
    protected $guarded = [];

    public function actions()
    {
        return $this->belongsToMany(Action::class, 'action_roles', 'role_id', 'action_id');
    }
    public function access()
    {
        return $this->hasMany(ActionRole::class, 'role_id');
    }
}
