<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Location extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = "locations";
    protected $fillable = ['name'];


    public function shifts()
    {
        return Shift::select('shifts.id', 'shifts.name')
            // ->join('dailies', 'shifts.id', '=', 'dailies.shift_id')
            // ->join('units', 'dailies.unit_id', '=', 'units.id')
            // ->join('locations', 'units.location_id', '=', 'locations.id')
            // ->where('locations.id', $this->id) // filter site saat dipanggil dari model
            ->groupBy('shifts.id', 'shifts.name')
            ->orderBy("name", "asc")
            ->get();
    }

    public function shift()
    {
        return $this->belongsToMany(Shift::class, 'dailies', 'location_id', 'shift_id')
            ->distinct()
            ->orderBy('name', 'asc');
    }


    public function units()
    {
        return $this->hasMany(Unit::class, 'location_id', );
    }
}