<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FormItemStatus extends Model
{
    use HasFactory;
    protected $table = 'form_item_statuses';

    protected $fillable = [
        'form_item_id',
        'status_id',
    ];

    /**
     * Relasi ke FormItem
     */
    public function formItem()
    {
        return $this->belongsTo(FormItem::class, 'form_item_id');
    }

    /**
     * Relasi ke Status
     */
    public function status()
    {
        return $this->belongsTo(Status::class, 'status_id');
    }
}
