<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FormItem extends Model
{
    use HasFactory;
    protected $table = 'form_items';
    protected $fillable = ["form_section_id", "name"];


    public function status()
    {
        return $this->belongsToMany(Status::class, 'form_item_statuses', "form_item_id", "status_id")->orderBy("id", "DESC");
    }
}